/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.util;

import com.necro.raid.dens.common.util.DoubleWeightedRandomMap;
import com.necro.raid.dens.common.util.RaidBucket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;

public class RaidBucketRegistry {
    public static final ResourceKey<Registry<RaidBucket>> BUCKET_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"raid", (String)"bucket"));
    public static Registry<RaidBucket> REGISTRY;
    public static Registry<Biome> BIOME_REGISTRY;
    private static final Map<ResourceLocation, RaidBucket> BUCKET_MAP;

    public static void register(RaidBucket bucket) {
        BUCKET_MAP.put(bucket.getId(), bucket);
    }

    public static ResourceLocation getRandomBucket(RandomSource random, Holder<Biome> biome) {
        HashSet candidates = new HashSet();
        BUCKET_MAP.forEach((location, bucket) -> {
            if (bucket.isValidBiome(biome)) {
                candidates.add(location);
            }
        });
        if (candidates.isEmpty()) {
            return null;
        }
        DoubleWeightedRandomMap<ResourceLocation> weightedMap = new DoubleWeightedRandomMap<ResourceLocation>();
        for (ResourceLocation bucket2 : candidates) {
            weightedMap.add(bucket2, RaidBucketRegistry.getBucket(bucket2).getWeight());
        }
        return weightedMap.getRandom(random).orElse(null);
    }

    public static RaidBucket getBucket(ResourceLocation bucket) {
        return BUCKET_MAP.getOrDefault(bucket, null);
    }

    public static void clear() {
        BUCKET_MAP.clear();
    }

    public static void init(MinecraftServer server) {
        REGISTRY = server.registryAccess().registryOrThrow(BUCKET_KEY);
        BIOME_REGISTRY = server.registryAccess().registryOrThrow(Registries.BIOME);
    }

    static {
        BUCKET_MAP = new HashMap<ResourceLocation, RaidBucket>();
    }
}

