/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.necro.raid.dens.common.raids.RaidFeature;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.RaidBucketRegistry;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class RaidBucket {
    private final HashSet<RaidTier> includeTiers;
    private final HashSet<RaidType> includeTypes;
    private final HashSet<RaidFeature> includeFeatures;
    private Set<ResourceLocation> includeBosses;
    private final HashSet<RaidTier> excludeTiers;
    private final HashSet<RaidType> excludeTypes;
    private final HashSet<RaidFeature> excludeFeatures;
    private Set<ResourceLocation> excludeBosses;
    private Set<ResourceKey<Biome>> biomes;
    private final double weight;
    private BitSet compiled;
    private ResourceLocation id;
    private final HashSet<String> includeBossesInner;
    private final HashSet<String> excludeBossesInner;
    private final HashSet<String> biomesInner;

    private RaidBucket(HashSet<RaidTier> includeTiers, HashSet<RaidType> includeTypes, HashSet<RaidFeature> includeFeatures, HashSet<String> includeBosses, HashSet<RaidTier> excludeTiers, HashSet<RaidType> excludeTypes, HashSet<RaidFeature> excludeFeatures, HashSet<String> excludeBosses, HashSet<String> biomes, double weight) {
        this.includeTiers = includeTiers;
        this.includeTypes = includeTypes;
        this.includeFeatures = includeFeatures;
        this.includeBosses = null;
        this.excludeTiers = excludeTiers;
        this.excludeTypes = excludeTypes;
        this.excludeFeatures = excludeFeatures;
        this.excludeBosses = null;
        this.biomes = null;
        this.weight = weight;
        this.compiled = null;
        this.id = null;
        this.includeBossesInner = includeBosses;
        this.excludeBossesInner = excludeBosses;
        this.biomesInner = biomes;
    }

    private HashSet<String> getBiomes() {
        return this.biomesInner;
    }

    public boolean isValidBiome(Holder<Biome> biome) {
        if (this.biomes == null) {
            this.resolveBiomes();
        }
        return this.biomes.stream().anyMatch(arg_0 -> biome.is(arg_0));
    }

    public double getWeight() {
        return this.weight;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getRandomRaidBoss(RandomSource random, Level level) {
        String key = String.valueOf(level.dimension().location()) + ":" + this.getId().toString();
        if (RaidRegistry.WEIGHTS_CACHE.containsKey(key)) {
            return RaidRegistry.roll(random, RaidRegistry.WEIGHTS_CACHE.get(key), RaidRegistry.INDEX_CACHE.get(key));
        }
        return RaidRegistry.getRandomRaidBoss(random, level, this.getCompiled(), key);
    }

    private void resolveBiomes() {
        HashSet<ResourceKey<Biome>> result = new HashSet<ResourceKey<Biome>>();
        for (String entry : this.biomesInner) {
            ResourceLocation id = ResourceLocation.parse((String)(entry.startsWith("#") ? entry.substring(1) : entry));
            if (entry.equals("*")) {
                result.addAll(RaidBucketRegistry.BIOME_REGISTRY.registryKeySet());
                break;
            }
            if (entry.startsWith("#")) {
                TagKey tag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)id);
                RaidBucketRegistry.BIOME_REGISTRY.getTag(tag).ifPresent(holderSet -> holderSet.forEach(holder -> {
                    if (holder.unwrapKey().isEmpty()) {
                        return;
                    }
                    result.add((ResourceKey)holder.unwrapKey().get());
                }));
                continue;
            }
            ResourceKey biomeKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)id);
            if (!RaidBucketRegistry.BIOME_REGISTRY.containsKey(biomeKey)) continue;
            result.add((ResourceKey<Biome>)biomeKey);
        }
        this.biomes = result;
    }

    private void resolveRaidBosses() {
        HashSet<ResourceLocation> result = new HashSet<ResourceLocation>();
        for (String entry : this.includeBossesInner) {
            ResourceLocation id = ResourceLocation.parse((String)(entry.startsWith("#") ? entry.substring(1) : entry));
            if (entry.startsWith("#")) {
                result.addAll(RaidRegistry.getTagEntries(id));
                continue;
            }
            if (RaidRegistry.getRaidBoss(id) == null) continue;
            result.add(id);
        }
        this.includeBosses = result;
        HashSet<ResourceLocation> result2 = new HashSet<ResourceLocation>();
        for (String entry : this.excludeBossesInner) {
            ResourceLocation id = ResourceLocation.parse((String)(entry.startsWith("#") ? entry.substring(1) : entry));
            if (entry.startsWith("#")) {
                result2.addAll(RaidRegistry.getTagEntries(id));
                continue;
            }
            if (RaidRegistry.getRaidBoss(id) == null) continue;
            result2.add(id);
        }
        this.excludeBosses = result2;
    }

    private BitSet getCompiled() {
        if (this.compiled == null) {
            boolean noIncludes;
            this.resolveRaidBosses();
            this.compiled = new BitSet();
            boolean bl = noIncludes = this.includeTiers.isEmpty() && this.includeTypes.isEmpty() && this.includeFeatures.isEmpty() && this.includeBosses.isEmpty();
            if (noIncludes) {
                this.compiled.set(0, RaidRegistry.RAID_LIST.size());
            }
            if (!this.includeTiers.isEmpty()) {
                BitSet tierSet = new BitSet();
                for (RaidTier tier : this.includeTiers) {
                    tierSet.or(RaidRegistry.RAIDS_BY_TIER.get((Object)tier));
                }
                this.compiled.and(tierSet);
            }
            if (!this.includeTypes.isEmpty()) {
                BitSet typeSet = new BitSet();
                for (RaidType type : this.includeTypes) {
                    typeSet.or(RaidRegistry.RAIDS_BY_TYPE.get((Object)type));
                }
                this.compiled.and(typeSet);
            }
            if (!this.includeFeatures.isEmpty()) {
                BitSet featureSet = new BitSet();
                for (RaidFeature feature : this.includeFeatures) {
                    featureSet.or(RaidRegistry.RAIDS_BY_FEATURE.get((Object)feature));
                }
                this.compiled.and(featureSet);
            }
            if (!this.includeBosses.isEmpty()) {
                BitSet bossSet = new BitSet();
                for (ResourceLocation raidBoss : this.includeBosses) {
                    Integer index = RaidRegistry.RAID_INDEX.get(raidBoss);
                    if (index == null) continue;
                    bossSet.set(index);
                }
                this.compiled.or(bossSet);
            }
            for (RaidTier tier : this.excludeTiers) {
                this.compiled.andNot(RaidRegistry.RAIDS_BY_TIER.get((Object)tier));
            }
            for (RaidType type : this.excludeTypes) {
                this.compiled.andNot(RaidRegistry.RAIDS_BY_TYPE.get((Object)type));
            }
            for (RaidFeature feature : this.excludeFeatures) {
                this.compiled.andNot(RaidRegistry.RAIDS_BY_FEATURE.get((Object)feature));
            }
            for (ResourceLocation raidBoss : this.excludeBosses) {
                Integer index = RaidRegistry.RAID_INDEX.get(raidBoss);
                if (index == null) continue;
                this.compiled.clear(index);
            }
        }
        return this.compiled;
    }

    private RaidBucketFilters getIncluded() {
        return new RaidBucketFilters(this.includeTiers, this.includeTypes, this.includeFeatures, this.includeBossesInner);
    }

    private RaidBucketFilters getExcluded() {
        return new RaidBucketFilters(this.excludeTiers, this.excludeTypes, this.excludeFeatures, this.excludeBossesInner);
    }

    public static Codec<RaidBucket> codec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)RaidBucketFilters.codec().optionalFieldOf("include", (Object)new RaidBucketFilters()).forGetter(RaidBucket::getIncluded), (App)RaidBucketFilters.codec().optionalFieldOf("exclude", (Object)new RaidBucketFilters()).forGetter(RaidBucket::getExcluded), (App)Codec.STRING.listOf().xmap(HashSet::new, ArrayList::new).fieldOf("biome").forGetter(RaidBucket::getBiomes), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)10.0).forGetter(RaidBucket::getWeight)).apply((Applicative)inst, (include, exclude, biomes, weight) -> new RaidBucket(include.tiers(), include.types(), include.features(), include.bosses(), exclude.tiers(), exclude.types(), exclude.features(), exclude.bosses(), (HashSet<String>)biomes, (double)weight)));
    }

    private record RaidBucketFilters(HashSet<RaidTier> tiers, HashSet<RaidType> types, HashSet<RaidFeature> features, HashSet<String> bosses) {
        public RaidBucketFilters() {
            this(new HashSet<RaidTier>(), new HashSet<RaidType>(), new HashSet<RaidFeature>(), new HashSet<String>());
        }

        private static Codec<RaidBucketFilters> codec() {
            return RecordCodecBuilder.create(inst -> inst.group((App)RaidTier.codec().listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf("tier", new HashSet()).forGetter(RaidBucketFilters::tiers), (App)RaidType.codec().listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf("type", new HashSet()).forGetter(RaidBucketFilters::types), (App)RaidFeature.codec().listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf("feature", new HashSet()).forGetter(RaidBucketFilters::features), (App)Codec.STRING.listOf().xmap(HashSet::new, ArrayList::new).optionalFieldOf("boss", new HashSet()).forGetter(RaidBucketFilters::bosses)).apply((Applicative)inst, RaidBucketFilters::new));
        }
    }
}

