/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.showdown.instructions;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.interpreter.Effect;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.moves.animations.ActionEffectContext;
import com.cobblemon.mod.common.api.moves.animations.ActionEffectTimeline;
import com.cobblemon.mod.common.api.moves.animations.ActionEffects;
import com.cobblemon.mod.common.api.moves.animations.UsersProvider;
import com.cobblemon.mod.common.api.pokemon.status.Status;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.ActionEffectInstruction;
import com.cobblemon.mod.common.battles.dispatch.CauserInstruction;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.battles.dispatch.InstructionSet;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.battles.interpreter.instructions.MoveInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.pokemon.status.statuses.persistent.PoisonStatus;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Unit;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RaidDamageInstruction
implements ActionEffectInstruction {
    private final InstructionSet instructionSet;
    private final BattleActor actor;
    private final BattleMessage publicMessage;
    private final BattleMessage privateMessage;
    private final BattlePokemon expectedTarget;
    private CompletableFuture<?> future;
    private Set<String> holds;

    public RaidDamageInstruction(InstructionSet instructionSet, BattleActor actor, BattleMessage publicMessage, BattleMessage privateMessage) {
        this.instructionSet = instructionSet;
        this.actor = actor;
        this.publicMessage = publicMessage;
        this.privateMessage = privateMessage;
        this.expectedTarget = this.publicMessage.battlePokemon(0, this.actor.getBattle());
        this.future = CompletableFuture.completedFuture(Unit.INSTANCE);
        this.holds = new HashSet<String>();
    }

    @NotNull
    public CompletableFuture<?> getFuture() {
        return this.future;
    }

    public void setFuture(@NotNull CompletableFuture<?> future) {
        this.future = future;
    }

    @NotNull
    public Set<String> getHolds() {
        return this.holds;
    }

    public void setHolds(@NotNull Set<String> set) {
        this.holds = set;
    }

    @NotNull
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_damage");
    }

    public void preActionEffect(@NotNull PokemonBattle battle) {
        if (this.expectedTarget == null) {
            return;
        }
        BattlePokemon source = this.privateMessage.battlePokemonFromOptional(battle, "of");
        if (source != null) {
            Effect effect = this.privateMessage.effect("from");
            ShowdownInterpreter.INSTANCE.broadcastOptionalAbility(battle, effect, source);
        }
    }

    public void runActionEffect(@NotNull PokemonBattle battle, @NotNull MoLangRuntime runtime) {
        battle.dispatch(() -> {
            Effect effect = this.privateMessage.effect("from");
            Status status = effect == null ? null : Statuses.getStatus((String)effect.getId());
            BattlePokemon pokemon = this.privateMessage.battlePokemon(0, battle);
            if (pokemon == null) {
                return DispatchResultKt.getGO();
            }
            if (status instanceof PoisonStatus) {
                PersistentStatusContainer container = pokemon.getEffectedPokemon().getStatus();
                status = container == null ? status : container.getStatus();
            }
            ActionEffectTimeline actionEffect = null;
            if (status != null) {
                actionEffect = status.getActionEffect();
            }
            if (actionEffect == null && effect != null) {
                String key = "damage_" + effect.getId();
                actionEffect = (ActionEffectTimeline)ActionEffects.INSTANCE.getActionEffects().get(MiscUtilsKt.cobblemonResource((String)key));
            }
            if (actionEffect == null) {
                actionEffect = (ActionEffectTimeline)ActionEffects.INSTANCE.getActionEffects().get(MiscUtilsKt.cobblemonResource((String)"generic_damage"));
            }
            if (actionEffect == null) {
                return DispatchResultKt.getGO();
            }
            ArrayList<PokemonBattle> providers = new ArrayList<PokemonBattle>(List.of(battle));
            providers.add((PokemonBattle)new UsersProvider(new Entity[]{this.expectedTarget.getEffectedPokemon().getEntity()}));
            ActionEffectContext context = new ActionEffectContext(actionEffect, new HashSet(), providers, runtime, false, false, new ArrayList(), ((ServerPlayer)battle.getPlayers().getFirst()).level());
            this.setFuture(actionEffect.run(context));
            this.setHolds(context.getHolds());
            this.future.thenAccept(v -> this.holds.clear());
            return DispatchResultKt.getGO();
        });
    }

    public void postActionEffect(@NotNull PokemonBattle battle) {
        RaidInstance raidInstance = ((IRaidBattle)battle).getRaidBattle();
        BattlePokemon battlePokemon = this.publicMessage.battlePokemon(0, this.actor.battle);
        if (battlePokemon == null || battlePokemon.getEntity() == null) {
            return;
        }
        if (!((IRaidAccessor)battlePokemon.getEntity()).isRaidBoss()) {
            return;
        }
        String args = this.privateMessage.argumentAt(1);
        assert (args != null);
        String damageStr = args.split(" ")[0];
        CauserInstruction lastCauser = this.instructionSet.getMostRecentCauser((InterpreterInstruction)this);
        Effect effect = this.privateMessage.effect("from");
        battle.dispatch(() -> {
            boolean causedFaint;
            MutableComponent pokemonName = battlePokemon.getName();
            BattlePokemon source = this.privateMessage.battlePokemonFromOptional(battle, "of");
            if (effect != null) {
                MutableComponent lang = null;
                if (Set.of("brn", "psn", "tox").contains(effect.getId())) {
                    Status status = Statuses.getStatus((String)effect.getId());
                    if (status != null) {
                        lang = LocalizationUtilsKt.lang((String)String.format("status.%s.hurt", status.getName().getPath()), (Object[])new Object[]{pokemonName});
                    }
                } else {
                    lang = Set.of("aftermath", "innardsout").contains(effect.getId()) ? LocalizationUtilsKt.battleLang((String)"damage.generic", (Object[])new Object[]{pokemonName}) : (Set.of("chloroblast", "steelbeam").contains(effect.getId()) ? LocalizationUtilsKt.battleLang((String)"damage.mindblown", (Object[])new Object[]{pokemonName}) : (effect.getId().equals("jumpkick") ? LocalizationUtilsKt.battleLang((String)"damage.highjumpkick", (Object[])new Object[]{pokemonName}) : LocalizationUtilsKt.battleLang((String)("damage." + effect.getId()), (Object[])new Object[]{pokemonName, source != null ? source.getName() : Component.literal((String)"UNKOWN")})));
                }
                if (lang != null) {
                    battle.broadcastChatMessage(lang);
                }
            }
            float damage = Float.parseFloat(damageStr);
            boolean bl = causedFaint = raidInstance.getRemainingHealth() < damage;
            if (causedFaint) {
                battle.getDispatches().clear();
                battle.dispatchToFront(() -> {
                    battlePokemon.getEffectedPokemon().setCurrentHealth(0);
                    battlePokemon.sendUpdate();
                    return DispatchResultKt.getGO();
                });
            }
            ServerPlayer player = (ServerPlayer)battle.getPlayers().getFirst();
            raidInstance.syncHealth(player, battle, damage);
            battlePokemon.getEffectedPokemon().setCurrentHealth((int)raidInstance.getRemainingHealth());
            if (lastCauser instanceof MoveInstruction && ((MoveInstruction)lastCauser).getActionEffect() != null && !causedFaint) {
                return new UntilDispatch(() -> ((MoveInstruction)lastCauser).getFuture().isDone());
            }
            if (causedFaint) {
                return DispatchResultKt.getGO();
            }
            return new UntilDispatch(() -> !this.getHolds().contains("effects"));
        });
    }
}

