/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.reloaders;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.reloaders.AbstractReloadImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class StatusEffectsReloadImpl
extends AbstractReloadImpl {
    protected final Map<String, String> statuses = new HashMap<String, String>();

    public StatusEffectsReloadImpl() {
        super("showdown/conditions", AbstractReloadImpl.DataType.JAVASCRIPT);
    }

    @Override
    protected void preLoad() {
    }

    @Override
    public void load(@NotNull ResourceManager manager) {
        if (ModCompat.MEGA_SHOWDOWN.isLoaded()) {
            return;
        }
        manager.listResources(this.path, path -> path.toString().endsWith(this.suffix())).forEach((id, resource) -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.open(), StandardCharsets.UTF_8));){
                String status = reader.lines().collect(Collectors.joining("\n"));
                String statusId = id.getPath().replace(this.idRemove, "").replace(this.suffix(), "");
                this.statuses.put(statusId, status);
            }
            catch (Exception e) {
                this.onError((ResourceLocation)id, e);
            }
        });
        this.postLoad();
    }

    @Override
    protected void onError(ResourceLocation id, Exception e) {
        CobblemonRaidDens.LOGGER.error("Failed to load status effect {}", (Object)id, (Object)e);
    }

    @Override
    protected void postLoad() {
    }
}

