/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.reloaders;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.raids.RaidBossAdditions;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.reloaders.AbstractReloadImpl;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class BossAdditionsReloadImpl
extends AbstractReloadImpl {
    private List<ResourceLocation> registry = null;
    private final List<RaidBossAdditions> additionsList = new ArrayList<RaidBossAdditions>();

    public BossAdditionsReloadImpl() {
        super("raid/boss_additions", AbstractReloadImpl.DataType.JSON);
    }

    @Override
    protected void preLoad() {
    }

    @Override
    protected void onLoad(ResourceLocation key, JsonObject object) {
        if (this.registry == null) {
            this.registry = new ArrayList<ResourceLocation>(RaidRegistry.getAll());
        }
        Optional<RaidBossAdditions> additionsOpt = RaidBossAdditions.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)object).result().map(Pair::getFirst);
        additionsOpt.ifPresent(this.additionsList::add);
    }

    @Override
    protected void onError(ResourceLocation id, Exception e) {
        CobblemonRaidDens.LOGGER.error("Failed to load boss additions {}", (Object)id, (Object)e);
    }

    @Override
    protected void postLoad() {
        this.additionsList.sort(Comparator.comparingInt(RaidBossAdditions::priority).reversed());
        this.additionsList.forEach(additions -> additions.apply(this.registry));
        RaidRegistry.registerAll();
        RaidTier.updateRandom();
    }
}

