/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.net.messages.client.battle.BattleApplyPassResponsePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.events.RaidEndEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RewardDistribution;
import com.necro.raid.dens.common.raids.RewardHandler;
import com.necro.raid.dens.common.showdown.bagitems.CheerBagItem;
import com.necro.raid.dens.common.showdown.events.CheerAttackShowdownEvent;
import com.necro.raid.dens.common.showdown.events.CheerDefenseShowdownEvent;
import com.necro.raid.dens.common.showdown.events.CheerHealShowdownEvent;
import com.necro.raid.dens.common.showdown.events.PlayerJoinShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ResetBossShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ResetPlayerShowdownEvent;
import com.necro.raid.dens.common.showdown.events.SetTerrainShowdownEvent;
import com.necro.raid.dens.common.showdown.events.SetWeatherShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ShieldAddShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ShieldRemoveShowdownEvent;
import com.necro.raid.dens.common.showdown.events.StartRaidShowdownEvent;
import com.necro.raid.dens.common.showdown.events.StatBoostShowdownEvent;
import com.necro.raid.dens.common.showdown.events.UseMoveShowdownEvent;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class RaidInstance {
    private static final Map<String, Consumer<PokemonBattle>> INSTRUCTION_MAP = new HashMap<String, Consumer<PokemonBattle>>();
    private final PokemonEntity bossEntity;
    private final RaidBoss raidBoss;
    private final ServerBossEvent bossEvent;
    private final List<PokemonBattle> battles;
    private final Map<UUID, Float> damageTracker;
    private final List<ServerPlayer> activePlayers;
    private final List<UUID> failedPlayers;
    private float currentHealth;
    private float maxHealth;
    private final float initMaxHealth;
    private final Map<Integer, List<String>> scriptByTurn;
    private final NavigableMap<Double, List<String>> scriptByHp;
    private final Map<UUID, Integer> cheersLeft;
    private final List<DelayedRunnable> runQueue;

    public RaidInstance(PokemonEntity entity) {
        this.bossEntity = entity;
        this.raidBoss = ((IRaidAccessor)entity).getRaidBoss();
        this.bossEvent = new ServerBossEvent((Component)((MutableComponent)entity.getName()).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.WHITE), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_10);
        this.battles = new ArrayList<PokemonBattle>();
        this.damageTracker = new HashMap<UUID, Float>();
        this.activePlayers = new ArrayList<ServerPlayer>();
        this.failedPlayers = new ArrayList<UUID>();
        this.currentHealth = this.maxHealth = (float)(this.raidBoss.getHealthMulti() * this.bossEntity.getPokemon().getMaxHealth());
        this.initMaxHealth = this.maxHealth;
        this.cheersLeft = new HashMap<UUID, Integer>();
        this.runQueue = new ArrayList<DelayedRunnable>();
        this.runQueue.add(new DelayedRunnable(() -> {
            if (this.bossEntity.isDeadOrDying()) {
                return;
            }
            for (ServerPlayer player : this.activePlayers) {
                if (player.level() == this.bossEntity.level()) continue;
                this.removePlayer(player);
            }
        }, 20, true));
        this.scriptByTurn = new HashMap<Integer, List<String>>();
        this.scriptByHp = new TreeMap<Double, List<String>>();
        this.raidBoss.getScript().forEach((key, scripts) -> {
            ArrayList<String> functions = new ArrayList<String>();
            for (String function : scripts.functions()) {
                if (!INSTRUCTION_MAP.containsKey(function) && !function.startsWith("USE_MOVE")) {
                    return;
                }
                functions.add(function);
            }
            try {
                if (key.startsWith("turn:")) {
                    this.scriptByTurn.put(Integer.parseInt(key.split(":")[1]), functions);
                } else if (key.startsWith("hp:")) {
                    double threshold = Double.parseDouble(key.split(":")[1]);
                    if ((double)(this.currentHealth / this.maxHealth) < threshold) {
                        return;
                    }
                    this.scriptByHp.put(threshold, functions);
                } else if (key.startsWith("after:") || key.startsWith("repeat:")) {
                    int time = Integer.parseInt(key.split(":")[1]) * 20;
                    this.runQueue.add(new DelayedRunnable(() -> {
                        for (String function : functions) {
                            Consumer<PokemonBattle> instruction = this.getInstructions(function);
                            if (instruction == null) continue;
                            this.battles.forEach(instruction);
                        }
                    }, time, key.startsWith("repeat:")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void addPlayer(ServerPlayer player, PokemonBattle battle) {
        TierConfig tierConfig = CobblemonRaidDens.TIER_CONFIG.get((Object)this.raidBoss.getTier());
        ((IRaidBattle)battle).setRaidBattle(this);
        new StartRaidShowdownEvent().send(battle);
        this.battles.add(battle);
        this.bossEvent.addPlayer(player);
        this.damageTracker.put(player.getUUID(), Float.valueOf(0.0f));
        if (!this.activePlayers.isEmpty() && tierConfig.multiplayerHealthMultiplier() > 1.0f) {
            this.applyHealthMulti(player);
        }
        if (this.scriptByTurn.containsKey(0)) {
            for (String function : this.scriptByTurn.remove(0)) {
                Consumer<PokemonBattle> script = this.getInstructions(function);
                if (script == null) continue;
                script.accept(battle);
            }
        }
        this.cheersLeft.put(player.getUUID(), tierConfig.maxCheers());
        this.activePlayers.add(player);
        RaidDenNetworkMessages.SYNC_HEALTH.accept(player, Float.valueOf(this.currentHealth / this.maxHealth));
    }

    public void addPlayer(PokemonBattle battle) {
        this.addPlayer((ServerPlayer)battle.getPlayers().getFirst(), battle);
    }

    private void applyHealthMulti(ServerPlayer newPlayer) {
        float bonusHealth = this.initMaxHealth * (CobblemonRaidDens.TIER_CONFIG.get((Object)this.raidBoss.getTier()).multiplayerHealthMultiplier() - 1.0f) * (float)this.activePlayers.size();
        float currentRatio = this.currentHealth / this.maxHealth;
        this.maxHealth = this.initMaxHealth + bonusHealth;
        this.currentHealth = this.maxHealth * currentRatio;
        this.battles.forEach(battle -> this.playerJoin((PokemonBattle)battle, (Player)newPlayer));
    }

    public void removePlayer(ServerPlayer player, PokemonBattle battle) {
        this.battles.remove(battle);
        ((IRaidBattle)battle).setRaidBattle(null);
        this.bossEvent.removePlayer(player);
        this.failedPlayers.add(player.getUUID());
    }

    public void removePlayer(PokemonBattle battle) {
        this.removePlayer((ServerPlayer)battle.getPlayers().getFirst(), battle);
    }

    public void removePlayer(ServerPlayer player) {
        this.bossEvent.removePlayer(player);
    }

    public void syncHealth(ServerPlayer player, PokemonBattle battle, float damage) {
        if (!this.activePlayers.contains(player) && ((IRaidBattle)battle).isRaidBattle()) {
            this.addPlayer(player, battle);
        }
        this.damageTracker.computeIfPresent(player.getUUID(), (uuid, totalDamage) -> Float.valueOf(totalDamage.floatValue() + damage));
        this.currentHealth = Math.clamp(this.currentHealth - damage, 0.0f, this.maxHealth);
        this.activePlayers.forEach(p -> RaidDenNetworkMessages.SYNC_HEALTH.accept((ServerPlayer)p, Float.valueOf(this.currentHealth / this.maxHealth)));
        if (this.currentHealth == 0.0f) {
            this.bossEvent.setProgress(this.currentHealth / this.maxHealth);
            this.queueStopRaid();
        } else {
            this.runQueue.add(new DelayedRunnable(() -> {
                this.bossEvent.setProgress(this.currentHealth / this.maxHealth);
                this.runScriptByHp((double)this.currentHealth / (double)this.maxHealth);
            }, 20));
        }
    }

    public List<ServerPlayer> getPlayers() {
        return this.activePlayers;
    }

    public float getRemainingHealth() {
        return this.currentHealth;
    }

    public boolean hasFailed(ServerPlayer player) {
        return this.failedPlayers.contains(player.getUUID());
    }

    public void tick() {
        this.runQueue.removeIf(DelayedRunnable::tick);
    }

    public void queueStopRaid() {
        this.queueStopRaid(true);
    }

    public void queueStopRaid(boolean raidSuccess) {
        this.runQueue.add(new DelayedRunnable(() -> this.stopRaid(raidSuccess), 60));
    }

    public void stopRaid(boolean raidSuccess) {
        this.bossEvent.setVisible(false);
        this.bossEvent.removeAllPlayers();
        if (raidSuccess) {
            this.bossEntity.setHealth(0.0f);
        }
        RaidHelper.ACTIVE_RAIDS.remove(((IRaidAccessor)this.bossEntity).getRaidId());
        this.battles.forEach(PokemonBattle::stop);
        if (this.raidBoss == null) {
            return;
        }
        if (raidSuccess) {
            this.handleSuccess();
        } else {
            this.handleFailed();
        }
    }

    private void handleSuccess() {
        Pokemon cachedReward;
        List<Object> failed;
        List<Object> success;
        int catches = this.raidBoss.getMaxCatches();
        if (catches == 0) {
            success = List.of();
            failed = this.activePlayers;
        } else if (CobblemonRaidDens.CONFIG.reward_distribution == RewardDistribution.SURVIVOR) {
            ArrayList<ServerPlayer> survivors = new ArrayList<ServerPlayer>();
            failed = new ArrayList<ServerPlayer>();
            for (ServerPlayer player2 : this.activePlayers) {
                if (this.failedPlayers.contains(player2.getUUID())) {
                    failed.add(player2);
                    continue;
                }
                survivors.add(player2);
            }
            if (catches > 0 && survivors.size() > catches) {
                Collections.shuffle(survivors);
                success = survivors.subList(0, catches);
                failed.addAll(survivors.subList(catches, survivors.size()));
            } else {
                success = survivors;
            }
        } else if (catches < 0 || this.activePlayers.size() < catches) {
            success = this.activePlayers;
            failed = List.of();
        } else {
            this.sortPlayers();
            success = this.activePlayers.subList(0, catches);
            failed = this.activePlayers.subList(catches, this.activePlayers.size());
        }
        if (CobblemonRaidDens.CONFIG.sync_rewards) {
            cachedReward = this.raidBoss.getRewardPokemon(null);
            cachedReward.setShiny(this.bossEntity.getPokemon().getShiny());
            cachedReward.setGender(this.bossEntity.getPokemon().getGender());
            cachedReward.setNature(this.bossEntity.getPokemon().getNature());
        } else {
            cachedReward = null;
        }
        success.forEach(player -> {
            new RewardHandler(this.raidBoss, (ServerPlayer)player, true, cachedReward).sendRewardMessage();
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((ServerPlayer)player, this.raidBoss, this.bossEntity.getPokemon(), true)});
        });
        failed.forEach(player -> {
            new RewardHandler(this.raidBoss, (ServerPlayer)player, false).sendRewardMessage();
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((ServerPlayer)player, this.raidBoss, this.bossEntity.getPokemon(), true)});
        });
        if (this.bossEntity != null && !this.bossEntity.isRemoved()) {
            this.bossEntity.discard();
        }
    }

    private void sortPlayers() {
        if (CobblemonRaidDens.CONFIG.reward_distribution == RewardDistribution.DAMAGE) {
            this.activePlayers.sort((a, b) -> Float.compare(this.damageTracker.getOrDefault(b.getUUID(), Float.valueOf(0.0f)).floatValue(), this.damageTracker.getOrDefault(a.getUUID(), Float.valueOf(0.0f)).floatValue()));
        } else {
            Collections.shuffle(this.activePlayers);
        }
    }

    private void handleFailed() {
        this.activePlayers.forEach(player -> {
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.raid_fail"));
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((ServerPlayer)player, this.raidBoss, this.bossEntity.getPokemon(), false)});
        });
    }

    public RaidBoss getRaidBoss() {
        return this.raidBoss;
    }

    private Consumer<PokemonBattle> getInstructions(@NotNull String function) {
        if (function.startsWith("USE_MOVE")) {
            String[] params = function.split("_");
            if (params.length != 4) {
                return null;
            }
            String move = params[2].toLowerCase();
            int target = Integer.parseInt(params[3]);
            return battle -> new UseMoveShowdownEvent(move, target).send((PokemonBattle)battle);
        }
        return INSTRUCTION_MAP.get(function);
    }

    public void runScriptByTurn(PokemonBattle battle, int turn) {
        List<String> functions = this.scriptByTurn.remove(turn);
        if (functions == null) {
            return;
        }
        for (String function : functions) {
            Consumer<PokemonBattle> script;
            if (function == null || (script = this.getInstructions(function)) == null) continue;
            script.accept(battle);
        }
    }

    public void runScriptByHp(double hpRatio) {
        this.scriptByHp.tailMap(hpRatio, true).values().forEach(functions -> this.battles.forEach(battle -> {
            for (String function : functions) {
                Consumer<PokemonBattle> script;
                if (function == null || (script = this.getInstructions(function)) == null) continue;
                script.accept((PokemonBattle)battle);
            }
        }));
        this.scriptByHp.keySet().removeIf(hp -> hp >= hpRatio);
    }

    public boolean runCheer(ServerPlayer player, PokemonBattle oBattle, CheerBagItem bagItem, String origin) {
        int cheersLeft = this.cheersLeft.getOrDefault(player.getUUID(), 0);
        if (cheersLeft <= 0) {
            return false;
        }
        this.cheersLeft.put(player.getUUID(), --cheersLeft);
        this.cheer(oBattle, bagItem, origin, false);
        Consumer<PokemonBattle> cheer = switch (bagItem.cheerType()) {
            default -> throw new MatchException(null, null);
            case CheerBagItem.CheerType.ATTACK -> battle -> new CheerAttackShowdownEvent(origin).send((PokemonBattle)battle);
            case CheerBagItem.CheerType.DEFENSE -> battle -> new CheerDefenseShowdownEvent(origin).send((PokemonBattle)battle);
            case CheerBagItem.CheerType.HEAL -> battle -> new CheerHealShowdownEvent(origin).send((PokemonBattle)battle);
        };
        for (PokemonBattle b : this.battles) {
            if (b == oBattle) continue;
            cheer.accept(b);
        }
        return true;
    }

    public void playerJoin(PokemonBattle battle, Player newPlayer) {
        new PlayerJoinShowdownEvent(newPlayer.getName().getString()).send(battle);
    }

    public void cheer(PokemonBattle battle, BagItem bagItem, String origin, boolean skipEnemyAction) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side1.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null || target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        if (bagItem instanceof CheerBagItem) {
            CheerBagItem.CheerType cheerType;
            CheerBagItem.CheerType cheerType2;
            CheerBagItem cheerBagItem = (CheerBagItem)bagItem;
            try {
                cheerType = cheerType2 = cheerBagItem.cheerType();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (cheerType == CheerBagItem.CheerType.HEAL && (cheerType2 = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon().getEntity()) instanceof PokemonEntity) {
                CheerBagItem.CheerType entity = cheerType2;
                entity.playSound(CobblemonSounds.MEDICINE_HERB_USE, 1.0f, 1.0f);
            }
        }
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse(bagItem, ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon(), origin), skipEnemyAction);
    }

    private void sendAction(BattleActor side1, BattleActor side2, ShowdownActionResponse response, boolean skipEnemyAction) {
        side1.getResponses().add(response);
        side1.setMustChoose(false);
        if (skipEnemyAction) {
            side2.getResponses().addFirst(PassActionResponse.INSTANCE);
            side2.setMustChoose(false);
        }
        side1.getBattle().checkForInputDispatch();
        side1.sendUpdate((NetworkPacket)new BattleApplyPassResponsePacket());
    }

    static {
        INSTRUCTION_MAP.put("RESET_BOSS", battle -> new ResetBossShowdownEvent().send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("RESET_PLAYER", battle -> new ResetPlayerShowdownEvent().send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_ATK_1", battle -> new StatBoostShowdownEvent((Stat)Stats.ATTACK, 1, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_ATK_2", battle -> new StatBoostShowdownEvent((Stat)Stats.ATTACK, 2, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_DEF_1", battle -> new StatBoostShowdownEvent((Stat)Stats.DEFENCE, 1, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_DEF_2", battle -> new StatBoostShowdownEvent((Stat)Stats.DEFENCE, 2, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_SPA_1", battle -> new StatBoostShowdownEvent((Stat)Stats.SPECIAL_ATTACK, 1, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_SPA_2", battle -> new StatBoostShowdownEvent((Stat)Stats.SPECIAL_ATTACK, 2, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_SPD_1", battle -> new StatBoostShowdownEvent((Stat)Stats.SPECIAL_DEFENCE, 1, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_SPD_2", battle -> new StatBoostShowdownEvent((Stat)Stats.SPECIAL_DEFENCE, 2, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_SPE_1", battle -> new StatBoostShowdownEvent((Stat)Stats.SPEED, 1, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_SPE_2", battle -> new StatBoostShowdownEvent((Stat)Stats.SPEED, 2, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_ACC_1", battle -> new StatBoostShowdownEvent((Stat)Stats.ACCURACY, 1, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_ACC_2", battle -> new StatBoostShowdownEvent((Stat)Stats.ACCURACY, 2, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_EVA_1", battle -> new StatBoostShowdownEvent((Stat)Stats.EVASION, 1, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("BOSS_EVA_2", battle -> new StatBoostShowdownEvent((Stat)Stats.EVASION, 2, 2).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_ATK_1", battle -> new StatBoostShowdownEvent((Stat)Stats.ATTACK, -1, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_ATK_2", battle -> new StatBoostShowdownEvent((Stat)Stats.ATTACK, -2, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_DEF_1", battle -> new StatBoostShowdownEvent((Stat)Stats.DEFENCE, -1, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_DEF_2", battle -> new StatBoostShowdownEvent((Stat)Stats.DEFENCE, -2, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_SPA_1", battle -> new StatBoostShowdownEvent((Stat)Stats.SPECIAL_ATTACK, -1, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_SPA_2", battle -> new StatBoostShowdownEvent((Stat)Stats.SPECIAL_ATTACK, -2, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_SPD_1", battle -> new StatBoostShowdownEvent((Stat)Stats.SPECIAL_DEFENCE, -1, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_SPD_2", battle -> new StatBoostShowdownEvent((Stat)Stats.SPECIAL_DEFENCE, -2, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_SPE_1", battle -> new StatBoostShowdownEvent((Stat)Stats.SPEED, 1, -1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_SPE_2", battle -> new StatBoostShowdownEvent((Stat)Stats.SPEED, 2, -1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_ACC_1", battle -> new StatBoostShowdownEvent((Stat)Stats.ACCURACY, -1, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_ACC_2", battle -> new StatBoostShowdownEvent((Stat)Stats.ACCURACY, -2, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_EVA_1", battle -> new StatBoostShowdownEvent((Stat)Stats.EVASION, -1, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("PLAYER_EVA_2", battle -> new StatBoostShowdownEvent((Stat)Stats.EVASION, -2, 1).send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SET_RAIN", battle -> new SetWeatherShowdownEvent("raindance").send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SET_SANDSTORM", battle -> new SetWeatherShowdownEvent("sandstorm").send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SET_SNOW", battle -> new SetWeatherShowdownEvent("snow").send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SET_SUN", battle -> new SetWeatherShowdownEvent("sunnyday").send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SET_ELECTRIC_TERRAIN", battle -> new SetTerrainShowdownEvent("electricterrain").send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SET_GRASSY_TERRAIN", battle -> new SetTerrainShowdownEvent("grassyterrain").send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SET_MISTY_TERRAIN", battle -> new SetTerrainShowdownEvent("mistyterrain").send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SET_PSYCHIC_TERRAIN", battle -> new SetTerrainShowdownEvent("psychicterrain").send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SHIELD_UP", battle -> new ShieldAddShowdownEvent().send((PokemonBattle)battle));
        INSTRUCTION_MAP.put("SHIELD_DOWN", battle -> new ShieldRemoveShowdownEvent().send((PokemonBattle)battle));
    }

    private static class DelayedRunnable {
        private final Runnable runnable;
        private final int delay;
        private int tick;
        private final boolean repeat;

        public DelayedRunnable(Runnable runnable, int delay, boolean repeat) {
            this.runnable = runnable;
            this.delay = delay;
            this.tick = 0;
            this.repeat = repeat;
        }

        public DelayedRunnable(Runnable runnable, int delay) {
            this(runnable, delay, false);
        }

        public boolean tick() {
            if (++this.tick < this.delay) {
                return false;
            }
            this.runnable.run();
            if (this.repeat) {
                this.tick = 0;
            }
            return !this.repeat;
        }
    }
}

