/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.dimension;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import com.necro.raid.dens.common.mixins.dimension.HolderSetNamedAccessor;
import com.necro.raid.dens.common.mixins.dimension.MappedRegistryAccessor;
import com.necro.raid.dens.common.util.IRegistryRemover;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MappedRegistry.class})
public abstract class MappedRegistryMixin<T>
implements IRegistryRemover {
    @Shadow
    @Final
    private ObjectList<Holder.Reference<T>> byId;

    @Shadow
    public abstract ResourceKey<? extends Registry<T>> key();

    @Override
    public ObjectList<Holder.Reference<T>> getById() {
        return this.byId;
    }

    @Override
    public void removeDimension(ResourceLocation loc) {
        MappedRegistryAccessor accessor = (MappedRegistryAccessor)((Object)this);
        Object type = accessor.getByLocation().get(loc).value();
        ObjectList<Holder.Reference<T>> byId = this.getById();
        accessor.getToId().removeInt((Object)loc);
        for (int i = 0; i < byId.size(); ++i) {
            int n;
            Holder.Reference reference = (Holder.Reference)byId.get(i);
            if (reference == null || !reference.key().location().equals((Object)loc)) continue;
            byId.set(i, null);
            boolean bl = false;
            for (int j = 0; j < byId.size(); ++j) {
                n = byId.get(j) != null ? j : n;
            }
            byId.size((int)(n + true));
            break;
        }
        accessor.getByLocation().remove(loc);
        accessor.getByKey().remove(ResourceKey.create(this.key(), (ResourceLocation)loc));
        accessor.getByValue().remove(type);
        accessor.getRegistrationInfos().remove(type);
        Lifecycle stable = Lifecycle.stable();
        for (RegistrationInfo registrationInfo : accessor.getRegistrationInfos().values()) {
            stable.add(registrationInfo.lifecycle());
        }
        accessor.setRegistryLifecycle(stable);
        for (HolderSet.Named named : accessor.tags().values()) {
            HolderSetNamedAccessor set = (HolderSetNamedAccessor)named;
            ImmutableList.Builder list = ImmutableList.builder();
            for (Holder content : set.getContents()) {
                if (content.is(loc)) continue;
                list.add(content);
            }
            set.setContents(list.build());
        }
        if (accessor.getUnregisteredIntrusiveHolders() != null) {
            accessor.getUnregisteredIntrusiveHolders().remove(type);
        }
    }
}

