/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.compat.megashowdown;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.properties.AspectPropertyType;
import com.github.yajatkaul.mega_showdown.block.MegaShowdownBlocks;
import com.github.yajatkaul.mega_showdown.item.MegaShowdownItems;
import com.github.yajatkaul.mega_showdown.utils.GlowHandler;
import com.necro.raid.dens.common.raids.RaidType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public abstract class RaidDensMSDCompat {
    public static void setupTera(PokemonEntity pokemonEntity, Pokemon pokemon) {
        AspectPropertyType.INSTANCE.fromString("msd:tera_" + pokemon.getTeraType().showdownId()).apply(pokemon);
        AspectPropertyType.INSTANCE.fromString("play_tera").apply(pokemon);
        pokemon.getPersistentData().putBoolean("is_tera", true);
        GlowHandler.applyTeraGlow((PokemonEntity)pokemonEntity);
    }

    public static void setupDmax(PokemonEntity pokemonEntity, Pokemon pokemon) {
        AspectPropertyType.INSTANCE.fromString("msd:dmax").apply(pokemon);
        GlowHandler.applyDynamaxGlow((PokemonEntity)pokemonEntity);
    }

    public static ItemStack getTeraShard(RaidType raidType) {
        return switch (raidType) {
            case RaidType.FIGHTING -> ((Item)MegaShowdownItems.FIGHTING_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.FLYING -> ((Item)MegaShowdownItems.FLYING_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.POISON -> ((Item)MegaShowdownItems.POISON_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.GROUND -> ((Item)MegaShowdownItems.GROUND_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.ROCK -> ((Item)MegaShowdownItems.ROCK_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.BUG -> ((Item)MegaShowdownItems.BUG_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.GHOST -> ((Item)MegaShowdownItems.GHOST_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.STEEL -> ((Item)MegaShowdownItems.STEEL_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.FIRE -> ((Item)MegaShowdownItems.FIRE_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.WATER -> ((Item)MegaShowdownItems.WATER_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.GRASS -> ((Item)MegaShowdownItems.GRASS_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.ELECTRIC -> ((Item)MegaShowdownItems.ELECTRIC_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.PSYCHIC -> ((Item)MegaShowdownItems.PSYCHIC_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.ICE -> ((Item)MegaShowdownItems.ICE_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.DRAGON -> ((Item)MegaShowdownItems.DRAGON_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.DARK -> ((Item)MegaShowdownItems.DARK_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.FAIRY -> ((Item)MegaShowdownItems.FAIRY_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.STELLAR -> ((Item)MegaShowdownItems.STELLAR_TERA_SHARD.get()).getDefaultInstance();
            default -> ((Item)MegaShowdownItems.NORMAL_TERA_SHARD.get()).getDefaultInstance();
        };
    }

    public static ItemStack getMaxMushroom() {
        return ((Block)MegaShowdownBlocks.MAX_MUSHROOM.get()).asItem().getDefaultInstance();
    }
}

