/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.commands;

import com.cobblemon.mod.common.api.permission.Permission;
import com.cobblemon.mod.common.api.permission.PermissionLevel;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.commands.permission.RaidDenPermission;
import com.necro.raid.dens.common.dimensions.DimensionHelper;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RaidAdminCommands {
    private static final Permission RESET_CLEARS = new RaidDenPermission("command.resetclears", PermissionLevel.CHEAT_COMMANDS_AND_COMMAND_BLOCKS);
    private static final Permission REMOVE = new RaidDenPermission("command.remove", PermissionLevel.CHEAT_COMMANDS_AND_COMMAND_BLOCKS);
    private static final Permission REFRESH = new RaidDenPermission("command.refreshother", PermissionLevel.CHEAT_COMMANDS_AND_COMMAND_BLOCKS);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"crd").then(PermissionUtilsKt.permission((ArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"resetclears").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> RaidAdminCommands.resetClearsForAll((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"pos"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension")))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(RaidAdminCommands::resetClearsForPlayerAndPos)))).requires(CommandSourceStack::isPlayer)).executes(context -> RaidAdminCommands.resetClearsForAll((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"pos"))))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(RaidAdminCommands::resetClearsForPlayer)), (Permission)RESET_CLEARS, (boolean)true))).then(PermissionUtilsKt.permission((ArgumentBuilder)Commands.literal((String)"remove").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(RaidAdminCommands::removeDimension)), (Permission)REMOVE, (boolean)true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"refresh").then(PermissionUtilsKt.permission((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(source -> source.hasPermission(2))).executes(context -> RaidAdminCommands.refreshPlayer((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"player"))), (Permission)REFRESH, (boolean)true))).requires(CommandSourceStack::isPlayer)).executes(RaidAdminCommands::refreshPlayer)));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        RaidAdminCommands.register(dispatcher);
    }

    private static int refreshPlayer(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        if (RaidUtils.isCustomDimension((Level)player.serverLevel())) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"error.cobblemonraiddens.player_in_raid"));
            return 0;
        }
        RaidHelper.removeHost(player.getUUID());
        RaidHelper.removeParticipant(player.getUUID());
        if (RaidHelper.JOIN_QUEUE.containsKey(player)) {
            RaidHelper.JOIN_QUEUE.get(player).refundItem();
            RaidHelper.JOIN_QUEUE.remove(player);
        }
        ((CommandSourceStack)context.getSource()).sendSystemMessage(RaidHelper.getSystemMessage(Component.translatable((String)"message.cobblemonraiddens.command.refresh_player", (Object[])new Object[]{player.getName()})));
        return 1;
    }

    private static int refreshPlayer(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        return RaidAdminCommands.refreshPlayer(context, player);
    }

    private static int resetClearsForPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        RaidHelper.resetPlayerAllClearedRaids(player.getUUID());
        ((CommandSourceStack)context.getSource()).sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.command.reset_clears"));
        return 1;
    }

    private static int resetClearsForPlayerAndPos(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        BlockPos blockPos = BlockPosArgument.getBlockPos(context, (String)"pos");
        ServerLevel dimension = DimensionArgument.getDimension(context, (String)"dimension");
        BlockEntity blockEntity = dimension.getBlockEntity(blockPos);
        if (blockEntity instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
            RaidHelper.resetPlayerClearedRaid(raidCrystal.getUuid(), player.getUUID());
            ((CommandSourceStack)context.getSource()).sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.command.reset_clears"));
            raidCrystal.resetClears();
            return 1;
        }
        return 0;
    }

    private static int resetClearsForAll(CommandContext<CommandSourceStack> context, BlockPos blockPos) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        ServerLevel dimension = player.serverLevel();
        return RaidAdminCommands.resetClearsForAll(context, blockPos, dimension);
    }

    private static int resetClearsForAll(CommandContext<CommandSourceStack> context, BlockPos blockPos, ServerLevel dimension) {
        BlockEntity blockEntity = dimension.getBlockEntity(blockPos);
        if (blockEntity instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
            RaidHelper.resetClearedRaids(raidCrystal.getUuid());
            ((CommandSourceStack)context.getSource()).sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.command.reset_clears"));
            raidCrystal.resetClears();
            BlockState blockState = raidCrystal.getBlockState();
            dimension.setBlock(blockPos, (BlockState)blockState.setValue((Property)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
            return 1;
        }
        return 0;
    }

    private static int removeDimension(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level = DimensionArgument.getDimension(context, (String)"dimension");
        if (!RaidUtils.isCustomDimension((Level)level)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"error.cobblemonraiddens.invalid_dimension"));
            return 0;
        }
        if (!level.players().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"error.cobblemonraiddens.players_in_dimension"));
            return 0;
        }
        DimensionHelper.queueForRemoval((ResourceKey<Level>)level.dimension(), level);
        DimensionHelper.SYNC_DIMENSIONS.accept((Object)((CommandSourceStack)context.getSource()).getServer(), (Object)level.dimension(), (Object)false);
        ((CommandSourceStack)context.getSource()).sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.command.remove_dimension"));
        return 1;
    }
}

