/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.almanac;

import com.frikinjay.almanac.command.ReloadCommand;
import com.frikinjay.almanac.util.ItemNBTUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Almanac {
    public static final String MOD_ID = "almanac";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"almanac");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<Consumer<CommandDispatcher<CommandSourceStack>>> COMMAND_REGISTRATIONS = new ArrayList<Consumer<CommandDispatcher<CommandSourceStack>>>();
    private static final Map<String, ConfigEntry<?>> CONFIG_ENTRIES = new ConcurrentHashMap();
    public static Boolean pickedItems = false;

    public static void init() {
        Almanac.addCommandRegistration(ReloadCommand::register);
    }

    public static <T> T loadConfig(File configFile, Class<T> configClass) {
        T config = Almanac.loadConfigFromFile(configFile, configClass);
        if (config != null) {
            CONFIG_ENTRIES.put(configFile.getName(), new ConfigEntry<T>(config, configClass, configFile));
        }
        return config;
    }

    public static Object getConfigEntry(String configName) {
        return CONFIG_ENTRIES.get(configName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadConfigFromFile(File configFile, Class<T> configClass) {
        if (!configFile.exists()) return Almanac.createDefaultConfig(configClass);
        try (FileReader reader = new FileReader(configFile);){
            Object object = GSON.fromJson((Reader)reader, configClass);
            return (T)object;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config", (Throwable)e);
        }
        return Almanac.createDefaultConfig(configClass);
    }

    private static <T> T createDefaultConfig(Class<T> configClass) {
        try {
            return configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create default config", (Throwable)e);
            return null;
        }
    }

    public static void saveConfig(File configFile, Object config) {
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static void addCommandRegistration(Consumer<CommandDispatcher<CommandSourceStack>> registration) {
        COMMAND_REGISTRATIONS.add(registration);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        for (Consumer<CommandDispatcher<CommandSourceStack>> registration : COMMAND_REGISTRATIONS) {
            registration.accept(dispatcher);
        }
    }

    public static <T> void reloadConfig(String configName) {
        ConfigEntry<?> configEntry = CONFIG_ENTRIES.get(configName);
        if (configEntry != null) {
            Object newConfig = Almanac.loadConfigFromFile(configEntry.getConfigFile(), configEntry.getConfigClass());
            if (newConfig != null) {
                configEntry.updateConfig(newConfig);
                configEntry.repopulateEntries(newConfig);
                configEntry.notifyListeners(newConfig);
                ItemNBTUtil.resetCache();
                LOGGER.info("Reloaded and repopulated config: {}", (Object)configName);
            } else {
                LOGGER.warn("Failed to load config: {}", (Object)configName);
            }
        } else {
            LOGGER.warn("Config not found: {}", (Object)configName);
        }
    }

    public static <T> void addConfigChangeListener(File configFile, Consumer<T> listener) {
        ConfigEntry<?> entry = CONFIG_ENTRIES.get(configFile.getName());
        if (entry != null) {
            entry.addListener(listener);
        }
    }

    public static Set<String> getConfigEntryNames() {
        return CONFIG_ENTRIES.keySet();
    }

    public static File getConfigFile(String configName) {
        ConfigEntry<?> entry = CONFIG_ENTRIES.get(configName);
        return entry != null ? entry.getConfigFile() : null;
    }

    public static Class<?> getConfigClass(String configName) {
        ConfigEntry<?> entry = CONFIG_ENTRIES.get(configName);
        return entry != null ? entry.getConfigClass() : null;
    }

    public static void dropEquipmentOnDiscard(LivingEntity entity) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = entity.getItemBySlot(equipmentSlot);
            if (itemStack.isEmpty() || !((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("picked") || EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            entity.spawnAtLocation(itemStack);
            entity.setItemSlot(equipmentSlot, ItemStack.EMPTY);
        }
    }

    public static boolean hasNonCustomName(LivingEntity entity) {
        if (entity.hasCustomName()) {
            String customName = entity.getCustomName().getString();
            return Almanac.matchesStackedName(customName, (Entity)entity);
        }
        return true;
    }

    public static boolean matchesStackedName(String customName, Entity entity) {
        return Pattern.compile(Pattern.quote(Almanac.getLocalizedEntityName(entity.getType()).getString()) + " x\\d+").matcher(customName).find();
    }

    public static Component getLocalizedEntityName(EntityType<?> entityType) {
        String translationKey = entityType.getDescriptionId();
        return Component.translatable((String)translationKey);
    }

    private static class ConfigEntry<T> {
        private T config;
        private final Class<T> configClass;
        private final File configFile;
        private final List<Consumer<T>> listeners = new ArrayList<Consumer<T>>();

        public ConfigEntry(T config, Class<T> configClass, File configFile) {
            this.config = config;
            this.configClass = configClass;
            this.configFile = configFile;
        }

        public void updateConfig(T newConfig) {
            this.config = newConfig;
        }

        public void repopulateEntries(T newConfig) {
            if (this.config instanceof Set && newConfig instanceof Set) {
                ((Set)this.config).clear();
                ((Set)this.config).addAll((Set)newConfig);
            } else if (this.config instanceof List && newConfig instanceof List) {
                ((List)this.config).clear();
                ((List)this.config).addAll((List)newConfig);
            } else if (this.config instanceof Map && newConfig instanceof Map) {
                ((Map)this.config).clear();
                ((Map)this.config).putAll((Map)newConfig);
            }
        }

        public void addListener(Consumer<T> listener) {
            this.listeners.add(listener);
        }

        public void notifyListeners(T newConfig) {
            for (Consumer<T> listener : this.listeners) {
                listener.accept(newConfig);
            }
        }

        public Class<T> getConfigClass() {
            return this.configClass;
        }

        public File getConfigFile() {
            return this.configFile;
        }
    }
}

