/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.minecraft;

import java.util.function.Supplier;
import jeresources.api.conditionals.Conditional;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.distributions.DistributionTriangular;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.api.restrictions.BiomeRestriction;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.compatibility.CompatBase;
import jeresources.compatibility.minecraft.RenderHooks;
import jeresources.entry.DungeonEntry;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import jeresources.entry.WorldGenEntry;
import jeresources.util.LootTableFetcher;
import jeresources.util.LootTableHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.storage.loot.LootTable;

public class MinecraftCompat
extends CompatBase {
    @Override
    public void init(boolean worldGen) {
        this.registerVanillaMobs();
        this.registerDungeonLoot();
        if (worldGen) {
            this.registerOres();
        }
        this.registerVanillaPlants();
    }

    private void registerVanillaMobs() {
        LootTableFetcher lootTableFetcher = LootTableHelper.getLootTableFetcher();
        LootTableHelper.getAllMobLootTables().entrySet().stream().map(entry -> MobEntry.create((Supplier<LivingEntity>)((Supplier)entry.getValue()), lootTableFetcher.getLootTable((ResourceKey<LootTable>)((ResourceKey)entry.getKey())))).forEach(x$0 -> this.registerMob((MobEntry)x$0));
        this.registerMobRenderHook(Bat.class, RenderHooks.BAT);
        this.registerMobRenderHook(EnderDragon.class, RenderHooks.ENDER_DRAGON);
        this.registerMobRenderHook(ElderGuardian.class, RenderHooks.ELDER_GUARDIAN);
        this.registerMobRenderHook(Squid.class, RenderHooks.SQUID);
        this.registerMobRenderHook(Giant.class, RenderHooks.GIANT);
        this.registerMobRenderHook(Shulker.class, RenderHooks.SHULKER);
        this.registerMobRenderHook(AbstractSchoolingFish.class, RenderHooks.GROUP_FISH);
    }

    private void registerDungeonLoot() {
        LootTableFetcher lootTableFetcher = LootTableHelper.getLootTableFetcher();
        LootTableHelper.getAllChestLootTablesResourceKeys().stream().map(resourceKey -> new DungeonEntry(resourceKey.location().getPath(), lootTableFetcher.getLootTable((ResourceKey<LootTable>)resourceKey))).forEach(x$0 -> this.registerDungeonEntry((DungeonEntry)x$0));
    }

    private void registerOres() {
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.COAL_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_COAL_ORE), (DistributionBase)new DistributionSquare(30, 16, 136, 256), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.COAL), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.COAL_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_COAL_ORE), (DistributionBase)new DistributionTriangular(20, 16, 96, 96), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.COAL), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.COPPER_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_COPPER_ORE), (DistributionBase)new DistributionTriangular(16, 8, 46, 66), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.RAW_COPPER), 2, 20, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.COPPER_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_COPPER_ORE), (DistributionBase)new DistributionTriangular(16, 16, 46, 66), new Restriction(BiomeRestriction.DRIPSTONE_CAVES, DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.RAW_COPPER), 2, 20, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.LAPIS_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_LAPIS_ORE), (DistributionBase)new DistributionSquare(4, 8, -64, 64), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.LAPIS_LAZULI), 4, 36, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.LAPIS_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_LAPIS_ORE), (DistributionBase)new DistributionTriangular(2, 8, 0, 32), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.LAPIS_LAZULI), 4, 36, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.IRON_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_IRON_ORE), (DistributionBase)new DistributionTriangular(90, 8, 232, 152), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.RAW_IRON), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.IRON_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_IRON_ORE), (DistributionBase)new DistributionTriangular(10, 8, 16, 40), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.RAW_IRON), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.IRON_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_IRON_ORE), (DistributionBase)new DistributionSquare(10, 8, -64, 72), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.RAW_IRON), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.GOLD_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_GOLD_ORE), (DistributionBase)new DistributionSquare(1, 8, -64, -48), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.RAW_GOLD), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.GOLD_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_GOLD_ORE), (DistributionBase)new DistributionTriangular(4, 8, -16, 48), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.RAW_GOLD), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.GOLD_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_GOLD_ORE), (DistributionBase)new DistributionTriangular(50, 8, -16, 48), new Restriction(BiomeRestriction.BADLANDS, DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.RAW_GOLD), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.REDSTONE_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_REDSTONE_ORE), (DistributionBase)new DistributionTriangular(8, 8, -64, 32), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.REDSTONE), 1, 32, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.REDSTONE_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_REDSTONE_ORE), (DistributionBase)new DistributionSquare(4, 8, -64, 15), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.REDSTONE), 1, 32, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.DIAMOND_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_DIAMOND_ORE), (DistributionBase)new DistributionTriangular(6, 6, -64, 64), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.DIAMOND), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.EMERALD_ORE), new ItemStack((ItemLike)Blocks.DEEPSLATE_EMERALD_ORE), (DistributionBase)new DistributionTriangular(100, 4, 202, 218), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.EMERALD), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.NETHER_QUARTZ_ORE), (DistributionBase)new DistributionSquare(16, 16, 10, 128), new Restriction(DimensionRestriction.NETHER), true, new LootDrop(new ItemStack((ItemLike)Items.QUARTZ), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.NETHER_GOLD_ORE), (DistributionBase)new DistributionSquare(8, 16, 15, 117), new Restriction(DimensionRestriction.NETHER), true, new LootDrop(new ItemStack((ItemLike)Items.GOLD_NUGGET), 2, 24, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.ANCIENT_DEBRIS), (DistributionBase)new DistributionTriangular(14, 9, 1.6E-4f), new Restriction(DimensionRestriction.NETHER), new LootDrop[0]));
    }

    private void registerVanillaPlants() {
        PlantDrop potato = new PlantDrop(new ItemStack((ItemLike)Items.POTATO), 1, 4);
        PlantDrop poisonous = new PlantDrop(new ItemStack((ItemLike)Items.POISONOUS_POTATO), 0.02f);
        this.registerPlant(new PlantEntry((PotatoBlock)Blocks.POTATOES, potato, poisonous));
        PlantDrop carrot = new PlantDrop(new ItemStack((ItemLike)Items.CARROT), 1, 4);
        this.registerPlant(new PlantEntry((CarrotBlock)Blocks.CARROTS, carrot));
        PlantDrop wheat = new PlantDrop(new ItemStack((ItemLike)Items.WHEAT), 1, 1);
        PlantDrop seeds = new PlantDrop(new ItemStack((ItemLike)Items.WHEAT_SEEDS), 0, 3);
        this.registerPlant(new PlantEntry((CropBlock)Blocks.WHEAT, wheat, seeds));
        PlantDrop melonSlice = new PlantDrop(new ItemStack((ItemLike)Items.MELON_SLICE), 3, 7);
        this.registerPlant(new PlantEntry((StemBlock)Blocks.MELON_STEM, melonSlice));
        PlantDrop pumpkin = new PlantDrop(new ItemStack((ItemLike)Blocks.PUMPKIN), 1, 1);
        this.registerPlant(new PlantEntry((StemBlock)Blocks.PUMPKIN_STEM, pumpkin));
        PlantDrop beetroot = new PlantDrop(new ItemStack((ItemLike)Items.BEETROOT), 1, 1);
        PlantDrop beetrootSeeds = new PlantDrop(new ItemStack((ItemLike)Items.BEETROOT_SEEDS), 0, 3);
        this.registerPlant(new PlantEntry((BeetrootBlock)Blocks.BEETROOTS, beetroot, beetrootSeeds));
        PlantDrop netherWartDrop = new PlantDrop(new ItemStack((ItemLike)Items.NETHER_WART), 2, 4);
        PlantEntry netherWartEntry = new PlantEntry((NetherWartBlock)Blocks.NETHER_WART, netherWartDrop);
        netherWartEntry.setSoil(Blocks.SOUL_SAND.defaultBlockState());
        this.registerPlant(netherWartEntry);
        PlantDrop sweetBerriesDrop = new PlantDrop(new ItemStack((ItemLike)Items.SWEET_BERRIES), 1, 3);
        PlantEntry sweetBerriesEntry = new PlantEntry((SweetBerryBushBlock)Blocks.SWEET_BERRY_BUSH, sweetBerriesDrop);
        sweetBerriesEntry.setSoil(Blocks.GRASS_BLOCK.defaultBlockState());
        this.registerPlant(sweetBerriesEntry);
    }
}

