/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.kit.KitManager;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.SavedTeleportManager;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class FTBEWorldData {
    private static final LevelResource FTBESSENTIALS_DIRECTORY = new LevelResource("ftbessentials");
    private static final String DATA_FILE = "data.snbt";
    public static FTBEWorldData instance;
    private final MinecraftServer server;
    private boolean needSave;
    private final SavedTeleportManager.WarpManager warpManager;
    private final Map<UUID, Long> muteTimeouts;

    public FTBEWorldData(MinecraftServer s) {
        this.server = s;
        this.warpManager = new SavedTeleportManager.WarpManager(this);
        this.muteTimeouts = new HashMap<UUID, Long>();
    }

    public SavedTeleportManager.WarpManager warpManager() {
        return this.warpManager;
    }

    public Path mkdirs(String path) {
        Path dir = this.server.getWorldPath(FTBESSENTIALS_DIRECTORY);
        if (!path.isEmpty()) {
            dir = dir.resolve(path);
        }
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not create FTB Essentials data directory: " + String.valueOf(ex));
            }
        }
        return dir;
    }

    public void markDirty() {
        this.needSave = true;
    }

    public void saveIfChanged() {
        if (this.needSave && SNBT.write((Path)this.mkdirs("").resolve(DATA_FILE), (CompoundTag)this.toNBT())) {
            this.needSave = false;
        }
    }

    public void load() {
        try {
            SNBTCompoundTag tag = SNBT.read((Path)this.mkdirs("").resolve(DATA_FILE));
            if (tag != null) {
                this.loadNBT(tag);
            }
        }
        catch (Exception ex) {
            FTBEssentials.LOGGER.error("Failed to load world data: {}", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private SNBTCompoundTag toNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.put("warps", (Tag)this.warpManager.writeNBT());
        SNBTCompoundTag mutesTag = new SNBTCompoundTag();
        this.muteTimeouts.forEach((id, until) -> mutesTag.putLong(id.toString(), until.longValue()));
        tag.put("mute_timeouts", (Tag)mutesTag);
        tag.put("kits", (Tag)KitManager.getInstance().save((HolderLookup.Provider)this.server.registryAccess()));
        return tag;
    }

    public void loadNBT(SNBTCompoundTag tag) {
        this.warpManager.readNBT((CompoundTag)tag.getCompound("warps"));
        this.muteTimeouts.clear();
        SNBTCompoundTag mutesTag = tag.getCompound("mute_timeouts");
        for (String key : mutesTag.getAllKeys()) {
            this.muteTimeouts.put(UUID.fromString(key), mutesTag.getLong(key));
        }
        KitManager.getInstance().load((CompoundTag)tag.getCompound("kits"), (HolderLookup.Provider)this.server.registryAccess());
    }

    public void tickMuteTimeouts(MinecraftServer server) {
        long now = System.currentTimeMillis();
        HashSet toExpire = new HashSet();
        this.muteTimeouts.forEach((id, expiry) -> {
            if (now >= expiry) {
                toExpire.add(id);
            }
        });
        toExpire.forEach(id -> {
            ServerPlayer player = server.getPlayerList().getPlayer(id);
            if (player != null) {
                player.displayClientMessage((Component)player.getDisplayName().copy().append(" is no longer muted"), false);
            }
            FTBEPlayerData.getOrCreate(server, id).ifPresent(data -> {
                data.setMuted(false);
                data.saveIfChanged();
                FTBEssentials.LOGGER.info("auto-unmuted {} - timeout expired", id);
            });
            this.muteTimeouts.remove(id);
            this.markDirty();
        });
    }

    public void setMuteTimeout(ServerPlayer player, long until) {
        if (until > 0L) {
            this.muteTimeouts.put(player.getUUID(), until);
        } else {
            this.muteTimeouts.remove(player.getUUID());
        }
        this.markDirty();
    }

    public Optional<Long> getMuteTimeout(ServerPlayer player) {
        return Optional.ofNullable(this.muteTimeouts.get(player.getUUID()));
    }
}

