/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.misc;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.integration.PermissionsHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class NearCommand
implements FTBCommand {
    protected static final int DEFAULT_RADIUS = 200;
    protected static final int MAX_PLAYER_RADIUS = 16;

    @Override
    public boolean enabled() {
        return FTBEConfig.NEAR.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return Collections.singletonList((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"near").requires(CommandUtils.isGamemaster())).executes(context -> NearCommand.showNear((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), 200))).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> NearCommand.showNear((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"))))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> NearCommand.showNear((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), 200))).then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> NearCommand.showNear((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"))))));
    }

    private static int showNear(CommandSourceStack source, ServerPlayer target, int radius) {
        int max;
        if (!source.hasPermission(2) && source.isPlayer() && radius > (max = PermissionsHelper.getInstance().getInt(source.getPlayer(), 16, "ftbessentials.near.max_radius"))) {
            source.sendSuccess(() -> Component.translatable((String)"ftbessentials.feedback.limit_radius", (Object[])new Object[]{max}).withStyle(ChatFormatting.GOLD), false);
            radius = max;
        }
        int radius2 = radius * radius;
        List<ServerPlayer> l = target.getServer().getPlayerList().getPlayers().stream().filter(other -> other != target).filter(other -> other.distanceToSqr((Entity)target) < (double)radius2).sorted(Comparator.comparingDouble(o -> o.distanceToSqr((Entity)target))).toList();
        int r = radius;
        source.sendSuccess(() -> Component.translatable((String)"ftbessentials.near.players_within", (Object[])new Object[]{l.size(), r}).withStyle(ChatFormatting.YELLOW), false);
        l.forEach(player -> source.sendSuccess(() -> Component.literal((String)"\u2022 ").append(player.getDisplayName()).withStyle(ChatFormatting.AQUA).append(String.format(" - %5.2fm", Float.valueOf(player.distanceTo((Entity)target)))), false));
        return 1;
    }
}

