/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api;

import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import noobanidus.mods.lootr.common.api.IMarkChanged;
import noobanidus.mods.lootr.common.api.annotation.ServerOnly;
import org.jetbrains.annotations.Nullable;

public interface IOpeners
extends IMarkChanged {
    @ServerOnly
    @Nullable
    public Set<UUID> getVisualOpeners();

    @Nullable
    public Set<UUID> getActualOpeners();

    default public boolean addOpener(Player player) {
        boolean result1 = this.addVisualOpener(player);
        boolean result2 = this.addActualOpener(player);
        return result1 || result2;
    }

    default public boolean clearOpeners() {
        Set<UUID> openers = this.getVisualOpeners();
        if (openers == null) {
            return false;
        }
        if (!openers.isEmpty()) {
            openers.clear();
            this.markChanged();
            return true;
        }
        return false;
    }

    default public boolean addVisualOpener(UUID uuid) {
        Set<UUID> openers = this.getVisualOpeners();
        if (openers == null) {
            return false;
        }
        if (openers.add(uuid)) {
            this.markChanged();
            return true;
        }
        return false;
    }

    default public boolean hasVisualOpened(UUID uuid) {
        Set<UUID> openers = this.getVisualOpeners();
        if (openers == null) {
            return false;
        }
        return !openers.isEmpty() && openers.contains(uuid);
    }

    default public boolean removeVisualOpener(UUID uuid) {
        Set<UUID> openers = this.getVisualOpeners();
        if (openers == null) {
            return false;
        }
        if (openers.remove(uuid)) {
            this.markChanged();
            return true;
        }
        return false;
    }

    default public boolean addActualOpener(UUID uuid) {
        Set<UUID> openers = this.getActualOpeners();
        if (openers == null) {
            return false;
        }
        if (openers.add(uuid)) {
            this.markChanged();
            return true;
        }
        return false;
    }

    @Deprecated
    default public boolean hasOpened(UUID uuid) {
        return this.hasServerOpened(uuid);
    }

    default public boolean hasServerOpened(UUID uuid) {
        Set<UUID> openers = this.getActualOpeners();
        if (openers == null) {
            return false;
        }
        return !openers.isEmpty() && openers.contains(uuid);
    }

    @Deprecated
    default public boolean hasOpened(Player player) {
        return this.hasServerOpened(player.getUUID());
    }

    default public boolean hasServerOpened(Player player) {
        return this.hasServerOpened(player.getUUID());
    }

    default public boolean addActualOpener(Player player) {
        return this.addActualOpener(player.getUUID());
    }

    default public boolean addVisualOpener(Player player) {
        return this.addVisualOpener(player.getUUID());
    }

    default public boolean hasVisualOpened(Player player) {
        return this.hasVisualOpened(player.getUUID());
    }

    default public boolean removeVisualOpener(Player player) {
        return this.removeVisualOpener(player.getUUID());
    }
}

