/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.ArrayList;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotRemovePacket;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.levelscraft7.rustlingspots.spot.RustlingSpotService;
import net.levelscraft7.rustlingspots.spot.SpotRewardResolver;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class SpotTicker {
    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!RustlingSpotsServerConfig.GENERAL.enabled()) {
            ArrayList<RustlingSpot> toRemove = new ArrayList<RustlingSpot>(RustlingSpotService.MANAGER.getAll((ResourceKey<Level>)level2.dimension()));
            toRemove.forEach(spot -> this.removeSpot(level2, (RustlingSpot)spot));
            return;
        }
        ArrayList<RustlingSpot> pendingRemoval = new ArrayList<RustlingSpot>();
        for (RustlingSpot spot2 : RustlingSpotService.MANAGER.getAll((ResourceKey<Level>)level2.dimension())) {
            if (this.shouldDespawn(level2, spot2)) {
                pendingRemoval.add(spot2);
                continue;
            }
            ServerPlayer player = this.findInteractingPlayer(level2, spot2);
            if (player == null) continue;
            SpotRewardResolver.resolve(level2, player, spot2);
            pendingRemoval.add(spot2);
        }
        pendingRemoval.forEach(spot -> this.removeSpot(level2, (RustlingSpot)spot));
    }

    private boolean shouldDespawn(ServerLevel level, RustlingSpot spot) {
        if (!level.hasChunkAt(spot.getPosition())) {
            return true;
        }
        long age = level.getGameTime() - spot.getCreatedTick();
        if (age > (long)RustlingSpotsServerConfig.GENERAL.spotLifetimeTicks()) {
            return true;
        }
        double maxDistance = RustlingSpotsServerConfig.GENERAL.despawnIfNoPlayerWithin();
        double maxDistanceSq = maxDistance * maxDistance;
        return level.players().stream().noneMatch(p -> p.distanceToSqr((double)spot.getPosition().getX() + 0.5, (double)spot.getPosition().getY() + 0.5, (double)spot.getPosition().getZ() + 0.5) <= maxDistanceSq);
    }

    private ServerPlayer findInteractingPlayer(ServerLevel level, RustlingSpot spot) {
        Vec3 lowerCorner = Vec3.atLowerCornerOf((Vec3i)spot.getPosition());
        double interactionRadius = RustlingSpotsServerConfig.GENERAL.interactionRadius();
        double interactionVerticalAllowance = RustlingSpotsServerConfig.GENERAL.interactionVerticalAllowance();
        double interactionRadiusSq = interactionRadius * interactionRadius;
        AABB box = AABB.unitCubeFromLowerCorner((Vec3)lowerCorner).inflate(interactionRadius).expandTowards(0.0, interactionVerticalAllowance, 0.0);
        Vec3 spotCenter = lowerCorner.add(0.5, 0.5, 0.5);
        for (Player player : level.getEntitiesOfClass(Player.class, box)) {
            if (RustlingSpotService.INTERACTION_BLOCKER.isBlocked(player.getUUID(), level.getGameTime())) continue;
            double dx = player.getX() - spotCenter.x;
            double dz = player.getZ() - spotCenter.z;
            double dy = player.getY() - spotCenter.y;
            if (!(dy >= -interactionRadius) || !(dy <= interactionRadius + interactionVerticalAllowance) || !(dx * dx + dz * dz <= interactionRadiusSq)) continue;
            return (ServerPlayer)player;
        }
        return null;
    }

    private void removeSpot(ServerLevel level, RustlingSpot spot) {
        RustlingSpotService.MANAGER.remove(spot);
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new RustlingSpotRemovePacket(spot.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

