/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class SpotInteractionBlocker {
    private final Map<UUID, Long> blockedUntil = new ConcurrentHashMap<UUID, Long>();

    public void blockForTicks(UUID playerId, long currentTick, long delayTicks) {
        this.blockedUntil.put(playerId, currentTick + delayTicks);
    }

    public boolean isBlocked(UUID playerId, long currentTick) {
        Long until = this.blockedUntil.get(playerId);
        if (until == null) {
            return false;
        }
        if (currentTick >= until) {
            this.blockedUntil.remove(playerId);
            return false;
        }
        return true;
    }
}

