/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class RustlingSpotManager {
    private final Map<ResourceKey<Level>, Map<UUID, RustlingSpot>> perDimension = new ConcurrentHashMap<ResourceKey<Level>, Map<UUID, RustlingSpot>>();

    public Collection<RustlingSpot> getAll(ResourceKey<Level> dimension) {
        return this.perDimension.getOrDefault(dimension, Map.of()).values();
    }

    public Optional<RustlingSpot> get(ResourceKey<Level> dimension, UUID id) {
        return Optional.ofNullable((RustlingSpot)this.perDimension.getOrDefault(dimension, Map.of()).get(id));
    }

    public void add(RustlingSpot spot) {
        this.perDimension.computeIfAbsent(spot.getDimension(), dim -> new ConcurrentHashMap()).put(spot.getId(), spot);
    }

    public void remove(RustlingSpot spot) {
        Map<UUID, RustlingSpot> map = this.perDimension.get(spot.getDimension());
        if (map != null) {
            map.remove(spot.getId());
            if (map.isEmpty()) {
                this.perDimension.remove(spot.getDimension());
            }
        }
    }

    public boolean hasSpace(ResourceKey<Level> dimension, ChunkPos chunkPos, int maxPerDimension) {
        Map map = this.perDimension.getOrDefault(dimension, Map.of());
        if (map.size() >= maxPerDimension) {
            return false;
        }
        long inChunk = map.values().stream().filter(spot -> new ChunkPos(spot.getPosition()).equals((Object)chunkPos)).count();
        return inChunk < 1L;
    }

    public boolean isFarEnough(ResourceKey<Level> dimension, double minDistanceSq, BlockPos position) {
        return this.getAll(dimension).stream().allMatch(existing -> existing.getPosition().distSqr((Vec3i)position) >= minDistanceSq);
    }

    public double nearestDistanceSq(ResourceKey<Level> dimension, BlockPos position) {
        return this.getAll(dimension).stream().mapToDouble(existing -> existing.getPosition().distSqr((Vec3i)position)).min().orElse(-1.0);
    }

    public long countWithin(ResourceKey<Level> dimension, BlockPos position, double radius) {
        double radiusSq = radius * radius;
        return this.getAll(dimension).stream().filter(existing -> existing.getPosition().distSqr((Vec3i)position) <= radiusSq).count();
    }
}

