/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.Optional;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamilyConfigService;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public enum RustlingSpotFamily {
    GRASS,
    SAND,
    WATER,
    SNOW,
    LEAVES,
    CAVE,
    NETHERFLAMME,
    SOULFLAME,
    FLYING;


    public static Optional<RustlingSpotFamily> fromSurfaceBlock(BlockState state, Level level, BlockPos pos) {
        BlockState above;
        Optional<RustlingSpotFamily> configured = RustlingSpotFamilyConfigService.resolve(state, level, pos);
        if (configured.isPresent()) {
            return configured;
        }
        if (state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.DIRT_PATH) || state.is(BlockTags.SMALL_FLOWERS)) {
            return Optional.of(GRASS);
        }
        if (state.is(Blocks.SAND) || state.is(Blocks.RED_SAND)) {
            return Optional.of(SAND);
        }
        FluidState fluid = state.getFluidState();
        if (fluid.isSource() && state.is(Blocks.WATER) && (above = level.getBlockState(pos.above())).isAir()) {
            return Optional.of(WATER);
        }
        if (state.is(Blocks.SNOW) || state.is(Blocks.SNOW_BLOCK) || state.is(Blocks.POWDER_SNOW)) {
            return Optional.of(SNOW);
        }
        if (state.is(BlockTags.LEAVES)) {
            return Optional.of(LEAVES);
        }
        if ((state.is(BlockTags.BASE_STONE_OVERWORLD) || state.is(Blocks.DEEPSLATE)) && !level.canSeeSkyFromBelowWater(pos.above()) && level.getBlockState(pos.above()).isAir()) {
            return Optional.of(CAVE);
        }
        if (level.dimension().equals(Level.NETHER)) {
            if (state.is(Blocks.NETHERRACK)) {
                return Optional.of(NETHERFLAMME);
            }
            if (state.is(Blocks.LAVA) && state.getFluidState().isSource() && level.getBlockState(pos.above()).isAir()) {
                return Optional.of(NETHERFLAMME);
            }
            if (state.is(Blocks.SOUL_SAND) || state.is(Blocks.SOUL_SOIL)) {
                return Optional.of(SOULFLAME);
            }
        }
        if (level.canSeeSkyFromBelowWater(pos.above()) && level.getBlockState(pos.above()).isAir()) {
            return Optional.of(FLYING);
        }
        return Optional.empty();
    }
}

