/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public final class RustlingMessages {
    private static final List<String> POKEMON_MESSAGE_KEYS = List.of("message.rustlingspots.pokemon.1", "message.rustlingspots.pokemon.2", "message.rustlingspots.pokemon.3");
    private static final List<String> LOOT_MESSAGE_KEYS = List.of("message.rustlingspots.loot.1", "message.rustlingspots.loot.2", "message.rustlingspots.loot.3");

    private RustlingMessages() {
    }

    public static Component randomPokemonMessage(String pokemon, RandomSource random) {
        String key = RustlingMessages.pickRandom(POKEMON_MESSAGE_KEYS, random);
        return Component.translatable((String)key, (Object[])new Object[]{pokemon});
    }

    public static Component randomLootMessage(ItemStack stack, RandomSource random) {
        String key = RustlingMessages.pickRandom(LOOT_MESSAGE_KEYS, random);
        return Component.translatable((String)key, (Object[])new Object[]{stack.getCount(), stack.getHoverName()});
    }

    private static String pickRandom(List<String> templates, RandomSource random) {
        if (templates.isEmpty()) {
            return "";
        }
        return templates.get(random.nextInt(templates.size()));
    }
}

