/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.Optional;
import net.levelscraft7.rustlingspots.config.RustlingSpotsPokemonConfig;
import net.levelscraft7.rustlingspots.spot.PokemonPoolService;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PokemonSpawnResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PokemonSpawnResolver.class);

    private PokemonSpawnResolver() {
    }

    public static Optional<String> spawn(ServerLevel level, ServerPlayer player, RustlingSpot spot, RandomSource random) {
        if (!RustlingSpotsPokemonConfig.POKEMON_SPAWN.enable()) {
            return Optional.empty();
        }
        PokemonPoolService.PokemonEntry entry = PokemonPoolService.pickRandom(level, spot, random);
        if (entry == null) {
            return Optional.empty();
        }
        String species = PokemonSpawnResolver.sanitizeSpecies(entry.species());
        if (species.isEmpty()) {
            LOGGER.warn("Failed to resolve Pok\u00e9mon species '{}' for rustling spot", (Object)entry.species());
            return Optional.empty();
        }
        boolean shiny = PokemonSpawnResolver.resolveShiny(random, entry);
        int levelRoll = PokemonSpawnResolver.randomLevel(entry, random);
        return PokemonSpawnResolver.tryCobblemonSpawn(level, player, spot, species, shiny, levelRoll).map(PokemonSpawnResolver::formatForMessage);
    }

    private static Optional<String> tryCobblemonSpawn(ServerLevel level, ServerPlayer player, RustlingSpot spot, String species, boolean shiny, int rolledLevel) {
        if (level.getServer() == null) {
            return Optional.empty();
        }
        Vec3 spawnOrigin = Vec3.atCenterOf((Vec3i)spot.getPosition());
        CommandSourceStack source = level.getServer().createCommandSourceStack().withLevel(level).withPermission(2).withPosition(spawnOrigin).withSuppressedOutput();
        String command = "pokespawn " + species + " level=" + rolledLevel + (shiny ? " shiny" : "");
        try {
            int result = level.getServer().getCommands().getDispatcher().execute(command, (Object)source);
            if (result <= 0) {
                LOGGER.warn("Cobblemon not present or failed to spawn Pok\u00e9mon {}", (Object)species);
                return Optional.empty();
            }
            return Optional.of(species);
        }
        catch (Exception e) {
            LOGGER.warn("Error while executing Cobblemon spawn command for {}", (Object)species, (Object)e);
            return Optional.empty();
        }
    }

    private static boolean resolveShiny(RandomSource random, PokemonPoolService.PokemonEntry entry) {
        if (entry.shiny() != null) {
            return entry.shiny();
        }
        if (entry.shinyChance() != null) {
            return random.nextDouble() < entry.shinyChance();
        }
        return random.nextDouble() < RustlingSpotsPokemonConfig.POKEMON_SPAWN.defaultShinyChance();
    }

    private static String sanitizeSpecies(String raw) {
        if (raw == null) {
            return "";
        }
        String trimmed = raw.trim();
        int idx = trimmed.indexOf(":");
        return idx >= 0 ? trimmed.substring(idx + 1) : trimmed;
    }

    private static int randomLevel(PokemonPoolService.PokemonEntry entry, RandomSource random) {
        int min = entry.resolvedMinLevel();
        int max = entry.resolvedMaxLevel();
        if (max < min) {
            return min;
        }
        return random.nextInt(max - min + 1) + min;
    }

    private static String formatForMessage(String speciesId) {
        if (speciesId.isEmpty()) {
            return speciesId;
        }
        String cleaned = PokemonSpawnResolver.sanitizeSpecies(speciesId);
        return cleaned.substring(0, 1).toUpperCase() + cleaned.substring(1);
    }
}

