/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.levelscraft7.rustlingspots.config.RustlingSpotsPokemonConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PokemonPoolService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PokemonPoolService.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path BASE = FMLPaths.CONFIGDIR.get().resolve("rustlingspots");
    private static final Path POKEMON_DIR = BASE.resolve("pokemon");
    private static final Path FAMILY_DIR = POKEMON_DIR.resolve("families");
    private static final AtomicBoolean LOADED = new AtomicBoolean(false);
    private static final List<PokemonEntry> ENTRIES = new ArrayList<PokemonEntry>();
    private static final Map<RustlingSpotFamily, String> DEFAULT_FAMILY = Map.of(RustlingSpotFamily.GRASS, "    [\n    { \"species\": \"hoppip\", \"weight\": 6, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"bellsprout\", \"weight\": 6, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"oddish\", \"weight\": 6, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"shroomish\", \"weight\": 5, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"seedot\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"sunkern\", \"weight\": 6, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"bulbasaur\", \"weight\": 2, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"treeko\", \"weight\": 2, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"rowlet\", \"weight\": 3, \"min_level\": 6, \"max_level\": 16 },\n    { \"species\": \"chikorita\", \"weight\": 4, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"turtwig\", \"weight\": 3, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"chespin\", \"weight\": 3, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"sprigatito\", \"weight\": 4, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"pansage\", \"weight\": 4, \"min_level\": 6, \"max_level\": 16 },\n    { \"species\": \"budew\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"petilil\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"cottonee\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"skiddo\", \"weight\": 5, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"bounsweet\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"lotad\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"lombre\", \"weight\": 2, \"min_level\": 20, \"max_level\": 35 },\n    { \"species\": \"oddish\", \"weight\": 4, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"gossifleur\", \"weight\": 5, \"min_level\": 4, \"max_level\": 20 },\n    { \"species\": \"bellsprout\", \"weight\": 4, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"heracross\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"nuzleaf\", \"weight\": 3, \"min_level\": 18, \"max_level\": 32 },\n    { \"species\": \"tangela\", \"weight\": 3, \"min_level\": 12, \"max_level\": 30 },\n    { \"species\": \"arboliva\", \"weight\": 1, \"min_level\": 28, \"max_level\": 50 },\n    { \"species\": \"pachirisu\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"sentret\", \"weight\": 5, \"min_level\": 2, \"max_level\": 12 },\n    { \"species\": \"furret\", \"weight\": 2, \"min_level\": 15, \"max_level\": 30 },\n    { \"species\": \"zigzagoon\", \"weight\": 6, \"min_level\": 2, \"max_level\": 14 },\n    { \"species\": \"skwovet\", \"weight\": 6, \"min_level\": 2, \"max_level\": 14 },\n    { \"species\": \"patrat\", \"weight\": 6, \"min_level\": 2, \"max_level\": 14 },\n    { \"species\": \"bidoof\", \"weight\": 6, \"min_level\": 2, \"max_level\": 14 },\n    { \"species\": \"stantler\", \"weight\": 3, \"min_level\": 12, \"max_level\": 28 },\n    { \"species\": \"deerling\", \"weight\": 5, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"sawsbuck\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"shinx\", \"weight\": 6, \"min_level\": 3, \"max_level\": 18 },\n    { \"species\": \"luxio\", \"weight\": 3, \"min_level\": 15, \"max_level\": 30 },\n    { \"species\": \"pichu\", \"weight\": 3, \"min_level\": 5, \"max_level\": 14 },\n    { \"species\": \"pikachu\", \"weight\": 2, \"min_level\": 12, \"max_level\": 28 },\n    { \"species\": \"eevee\", \"weight\": 3, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"glameow\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"meowth\", \"weight\": 4, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"skitty\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"yamper\", \"weight\": 5, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"growlithe\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"vulpix\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"larvesta\", \"weight\": 2, \"min_level\": 18, \"max_level\": 32 },\n    { \"species\": \"leafeon\", \"weight\": 1, \"min_level\": 28, \"max_level\": 48 },\n    { \"species\": \"pidgey\", \"weight\": 6, \"min_level\": 3, \"max_level\": 18 },\n    { \"species\": \"starly\", \"weight\": 6, \"min_level\": 3, \"max_level\": 18 },\n    { \"species\": \"fletchling\", \"weight\": 5, \"min_level\": 3, \"max_level\": 18 },\n    { \"species\": \"murkrow\", \"weight\": 3, \"min_level\": 12, \"max_level\": 26 },\n    { \"species\": \"swablu\", \"weight\": 3, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"drifloon\", \"weight\": 3, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"natu\", \"weight\": 3, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"combee\", \"weight\": 6, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"beedrill\", \"weight\": 2, \"min_level\": 18, \"max_level\": 32 },\n    { \"species\": \"kricketot\", \"weight\": 6, \"min_level\": 2, \"max_level\": 14 },\n    { \"species\": \"kricketune\", \"weight\": 3, \"min_level\": 15, \"max_level\": 30 },\n    { \"species\": \"scatterbug\", \"weight\": 6, \"min_level\": 2, \"max_level\": 12 },\n    { \"species\": \"applin\", \"weight\": 3, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"grubbin\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"spewpa\", \"weight\": 3, \"min_level\": 10, \"max_level\": 20 },\n    { \"species\": \"venonat\", \"weight\": 5, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"dwebble\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"rattata\", \"weight\": 6, \"min_level\": 2, \"max_level\": 12 },\n    { \"species\": \"sentret\", \"weight\": 6, \"min_level\": 2, \"max_level\": 12 },\n    { \"species\": \"buneary\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"minccino\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"salandit\", \"weight\": 3, \"min_level\": 14, \"max_level\": 26 },\n    { \"species\": \"phanpy\", \"weight\": 4, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"numel\", \"weight\": 4, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"marill\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"psyduck\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"toedscool\", \"weight\": 3, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"smoliv\", \"weight\": 4, \"min_level\": 4, \"max_level\": 14 },\n    { \"species\": \"pawmi\", \"weight\": 4, \"min_level\": 4, \"max_level\": 14 },\n    { \"species\": \"leafeon\", \"weight\": 1, \"min_level\": 30, \"max_level\": 50 }\n    ]\n", RustlingSpotFamily.WATER, "    [\n    { \"species\": \"magikarp\", \"weight\": 10, \"min_level\": 2, \"max_level\": 18 },\n    { \"species\": \"poliwag\", \"weight\": 6, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"psyduck\", \"weight\": 5, \"min_level\": 5, \"max_level\": 20 },\n    { \"species\": \"buizel\", \"weight\": 6, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"floatzel\", \"weight\": 3, \"min_level\": 20, \"max_level\": 32 },\n    { \"species\": \"lotad\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"lombre\", \"weight\": 3, \"min_level\": 14, \"max_level\": 30 },\n    { \"species\": \"marill\", \"weight\": 6, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"azumarill\", \"weight\": 2, \"min_level\": 22, \"max_level\": 40 },\n    { \"species\": \"slowpoke\", \"weight\": 4, \"min_level\": 10, \"max_level\": 28 },\n    { \"species\": \"slowking\", \"weight\": 1, \"min_level\": 28, \"max_level\": 45 },\n    { \"species\": \"slowbro\", \"weight\": 1, \"min_level\": 28, \"max_level\": 45 },\n    { \"species\": \"goldeen\", \"weight\": 6, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"seaking\", \"weight\": 2, \"min_level\": 20, \"max_level\": 36 },\n    { \"species\": \"tentacool\", \"weight\": 5, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"tentacruel\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"wingull\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"pelipper\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"finneon\", \"weight\": 5, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"lumineon\", \"weight\": 2, \"min_level\": 22, \"max_level\": 40 },\n    { \"species\": \"barboach\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"whiscash\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"wooper\", \"weight\": 6, \"min_level\": 2, \"max_level\": 14 },\n    { \"species\": \"quagsire\", \"weight\": 2, \"min_level\": 18, \"max_level\": 36 },\n    { \"species\": \"clodsire\", \"weight\": 1, \"min_level\": 25, \"max_level\": 45 },\n    { \"species\": \"froakie\", \"weight\": 2, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"frogadier\", \"weight\": 1, \"min_level\": 18, \"max_level\": 32 },\n    { \"species\": \"sobble\", \"weight\": 2, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"drizzile\", \"weight\": 1, \"min_level\": 18, \"max_level\": 32 },\n    { \"species\": \"piplup\", \"weight\": 2, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"prinplup\", \"weight\": 1, \"min_level\": 16, \"max_level\": 30 },\n    { \"species\": \"totodile\", \"weight\": 3, \"min_level\": 5, \"max_level\": 14 },\n    { \"species\": \"croconaw\", \"weight\": 1, \"min_level\": 16, \"max_level\": 28 },\n    { \"species\": \"squirtle\", \"weight\": 2, \"min_level\": 5, \"max_level\": 14 },\n    { \"species\": \"wartortle\", \"weight\": 1, \"min_level\": 18, \"max_level\": 32 },\n    { \"species\": \"oshawott\", \"weight\": 2, \"min_level\": 5, \"max_level\": 12 },\n    { \"species\": \"dewott\", \"weight\": 1, \"min_level\": 18, \"max_level\": 32 },\n    { \"species\": \"impidimp\", \"weight\": 3, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"swalot\", \"weight\": 1, \"min_level\": 22, \"max_level\": 38 },\n    { \"species\": \"gulpin\", \"weight\": 4, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"sandygast\", \"weight\": 3, \"min_level\": 12, \"max_level\": 26 },\n    { \"species\": \"shellos\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"gastrodon\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"feebas\", \"weight\": 1, \"min_level\": 5, \"max_level\": 20 },\n    { \"species\": \"milotic\", \"weight\": 1, \"min_level\": 25, \"max_level\": 45 },\n    { \"species\": \"staryu\", \"weight\": 4, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"starmie\", \"weight\": 1, \"min_level\": 22, \"max_level\": 40 },\n    { \"species\": \"clauncher\", \"weight\": 4, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"clawitzer\", \"weight\": 1, \"min_level\": 28, \"max_level\": 48 },\n    { \"species\": \"shellder\", \"weight\": 4, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"cloyster\", \"weight\": 1, \"min_level\": 22, \"max_level\": 40 },\n    { \"species\": \"frillish\", \"weight\": 3, \"min_level\": 12, \"max_level\": 26 },\n    { \"species\": \"jellicent\", \"weight\": 1, \"min_level\": 25, \"max_level\": 45 },\n    { \"species\": \"ducklett\", \"weight\": 4, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"swanna\", \"weight\": 1, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"popplio\", \"weight\": 2, \"min_level\": 5, \"max_level\": 14 },\n    { \"species\": \"brionne\", \"weight\": 1, \"min_level\": 18, \"max_level\": 32 },\n    { \"species\": \"finizen\", \"weight\": 3, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"palafin\", \"weight\": 1, \"min_level\": 20, \"max_level\": 45 },\n    { \"species\": \"togedemaru\", \"weight\": 3, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"qwilfish\", \"weight\": 4, \"min_level\": 8, \"max_level\": 20 }\n    ]\n", RustlingSpotFamily.SAND, "    [\n    { \"species\": \"sandshrew\", \"weight\": 6, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"sandile\", \"weight\": 5, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"hippopotas\", \"weight\": 4, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"trapinch\", \"weight\": 4, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"vulpix\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"growlithe\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"slugma\", \"weight\": 3, \"min_level\": 12, \"max_level\": 26 },\n    { \"species\": \"numel\", \"weight\": 4, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"houndour\", \"weight\": 3, \"min_level\": 12, \"max_level\": 30 },\n    { \"species\": \"helioptile\", \"weight\": 5, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"cacnea\", \"weight\": 4, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"maractus\", \"weight\": 2, \"min_level\": 20, \"max_level\": 38 },\n    { \"species\": \"yamask\", \"weight\": 3, \"min_level\": 14, \"max_level\": 30 },\n    { \"species\": \"baltoy\", \"weight\": 4, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"drilbur\", \"weight\": 4, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"diglett\", \"weight\": 6, \"min_level\": 2, \"max_level\": 14 },\n    { \"species\": \"geodude\", \"weight\": 5, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"onix\", \"weight\": 2, \"min_level\": 18, \"max_level\": 40 },\n    { \"species\": \"rockruff\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"lycanroc\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"glimmet\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"skorupi\", \"weight\": 4, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"stunky\", \"weight\": 4, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"grimer\", \"weight\": 4, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"meowth\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"persian\", \"weight\": 2, \"min_level\": 20, \"max_level\": 36 },\n    { \"species\": \"rhyhorn\", \"weight\": 3, \"min_level\": 16, \"max_level\": 32 },\n    { \"species\": \"larvesta\", \"weight\": 2, \"min_level\": 18, \"max_level\": 32 }\n    ]\n", RustlingSpotFamily.SNOW, "    [\n    { \"species\": \"swinub\", \"weight\": 6, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"sneasel\", \"weight\": 5, \"min_level\": 12, \"max_level\": 26 },\n    { \"species\": \"snorunt\", \"weight\": 5, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"bergmite\", \"weight\": 5, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"cubchoo\", \"weight\": 5, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"vulpix-alolan\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"growlithe-hisuian\", \"weight\": 4, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"teddiursa\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"spheal\", \"weight\": 4, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"deerling-winter\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"delibird\", \"weight\": 3, \"min_level\": 10, \"max_level\": 28 },\n    { \"species\": \"snom\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"piplup\", \"weight\": 3, \"min_level\": 5, \"max_level\": 14 },\n    { \"species\": \"prinplup\", \"weight\": 2, \"min_level\": 16, \"max_level\": 28 },\n    { \"species\": \"sylveon\", \"weight\": 1, \"min_level\": 28, \"max_level\": 48 },\n    { \"species\": \"stantler\", \"weight\": 3, \"min_level\": 12, \"max_level\": 30 },\n    { \"species\": \"avalugg\", \"weight\": 1, \"min_level\": 28, \"max_level\": 48 },\n    { \"species\": \"avalugg-hisuian\", \"weight\": 1, \"min_level\": 28, \"max_level\": 48 },\n    { \"species\": \"lapras\", \"weight\": 1, \"min_level\": 30, \"max_level\": 50 },\n    { \"species\": \"cryogonal\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"amaura\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 }\n    ]\n", RustlingSpotFamily.LEAVES, "    [\n    { \"species\": \"hoothoot\", \"weight\": 6, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"murkrow\", \"weight\": 4, \"min_level\": 12, \"max_level\": 26 },\n    { \"species\": \"rowlet\", \"weight\": 3, \"min_level\": 6, \"max_level\": 16 },\n    { \"species\": \"natu\", \"weight\": 5, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"hoppip\", \"weight\": 5, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"combee\", \"weight\": 6, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"scatterbug\", \"weight\": 6, \"min_level\": 2, \"max_level\": 12 },\n    { \"species\": \"applin\", \"weight\": 4, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"grubbin\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"pinsir\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"heracross\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"pichu\", \"weight\": 3, \"min_level\": 5, \"max_level\": 14 },\n    { \"species\": \"pikachu\", \"weight\": 2, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"shinx\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"eevee\", \"weight\": 3, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"skwovet\", \"weight\": 6, \"min_level\": 2, \"max_level\": 14 },\n    { \"species\": \"zigzagoon\", \"weight\": 6, \"min_level\": 2, \"max_level\": 14 },\n    { \"species\": \"starly\", \"weight\": 6, \"min_level\": 3, \"max_level\": 18 },\n    { \"species\": \"pidgey\", \"weight\": 6, \"min_level\": 3, \"max_level\": 18 },\n    { \"species\": \"fletchling\", \"weight\": 5, \"min_level\": 3, \"max_level\": 18 },\n    { \"species\": \"swablu\", \"weight\": 4, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"duskull\", \"weight\": 3, \"min_level\": 14, \"max_level\": 28 },\n    { \"species\": \"shuppet\", \"weight\": 3, \"min_level\": 14, \"max_level\": 28 },\n    { \"species\": \"misdreavus\", \"weight\": 2, \"min_level\": 16, \"max_level\": 32 },\n    { \"species\": \"teddiursa\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"buneary\", \"weight\": 4, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"minccino\", \"weight\": 4, \"min_level\": 4, \"max_level\": 16 },\n    { \"species\": \"pachirisu\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"smoliv\", \"weight\": 4, \"min_level\": 4, \"max_level\": 14 },\n    { \"species\": \"pawmi\", \"weight\": 4, \"min_level\": 4, \"max_level\": 14 },\n    { \"species\": \"toedscool\", \"weight\": 3, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"rowlet-hisuian\", \"weight\": 2, \"min_level\": 8, \"max_level\": 20 }\n    ]\n", RustlingSpotFamily.CAVE, "    [\n    { \"species\": \"zubat\", \"weight\": 6, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"geodude\", \"weight\": 5, \"min_level\": 6, \"max_level\": 22 },\n    { \"species\": \"woobat\", \"weight\": 5, \"min_level\": 4, \"max_level\": 20 },\n    { \"species\": \"roggenrola\", \"weight\": 4, \"min_level\": 8, \"max_level\": 24 },\n    { \"species\": \"onix\", \"weight\": 2, \"min_level\": 20, \"max_level\": 45 },\n    { \"species\": \"diglett\", \"weight\": 5, \"min_level\": 2, \"max_level\": 18 },\n    { \"species\": \"drilbur\", \"weight\": 5, \"min_level\": 6, \"max_level\": 22 },\n    { \"species\": \"mienfoo\", \"weight\": 3, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"sableye\", \"weight\": 2, \"min_level\": 22, \"max_level\": 40 },\n    { \"species\": \"mawile\", \"weight\": 2, \"min_level\": 22, \"max_level\": 38 },\n    { \"species\": \"golett\", \"weight\": 3, \"min_level\": 24, \"max_level\": 48 },\n    { \"species\": \"shinx\", \"weight\": 4, \"min_level\": 6, \"max_level\": 22 },\n    { \"species\": \"glimmet\", \"weight\": 2, \"min_level\": 28, \"max_level\": 50 },\n    { \"species\": \"dunsparce\", \"weight\": 4, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"whismur\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"salandit\", \"weight\": 4, \"min_level\": 10, \"max_level\": 25 },\n    { \"species\": \"carbink\", \"weight\": 1, \"min_level\": 35, \"max_level\": 60 },\n    { \"species\": \"makuhita\", \"weight\": 4, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"mankey\", \"weight\": 4, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"phanpy\", \"weight\": 4, \"min_level\": 8, \"max_level\": 24 },\n    { \"species\": \"cubone\", \"weight\": 3, \"min_level\": 12, \"max_level\": 32 },\n    { \"species\": \"timburr\", \"weight\": 3, \"min_level\": 15, \"max_level\": 32 },\n    { \"species\": \"axew\", \"weight\": 1, \"min_level\": 30, \"max_level\": 55 },\n    { \"species\": \"litwick\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"shuppet\", \"weight\": 3, \"min_level\": 14, \"max_level\": 28 },\n    { \"species\": \"gastly\", \"weight\": 3, \"min_level\": 14, \"max_level\": 26 },\n    { \"species\": \"pawniard\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"skorupi\", \"weight\": 3, \"min_level\": 12, \"max_level\": 26 },\n    { \"species\": \"sandshrew\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"paras\", \"weight\": 4, \"min_level\": 6, \"max_level\": 22 },\n    { \"species\": \"stunky\", \"weight\": 4, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"gulpin\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"grimer\", \"weight\": 4, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"machop\", \"weight\": 4, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"aron\", \"weight\": 3, \"min_level\": 18, \"max_level\": 40 },\n    { \"species\": \"larvitar\", \"weight\": 1, \"min_level\": 30, \"max_level\": 55 },\n    { \"species\": \"wooper\", \"weight\": 5, \"min_level\": 2, \"max_level\": 16 },\n    { \"species\": \"paldean-wooper\", \"weight\": 4, \"min_level\": 2, \"max_level\": 16 },\n    { \"species\": \"torkoal\", \"weight\": 2, \"min_level\": 24, \"max_level\": 42 },\n    { \"species\": \"baltoy\", \"weight\": 3, \"min_level\": 12, \"max_level\": 28 },\n    { \"species\": \"drifloon\", \"weight\": 3, \"min_level\": 12, \"max_level\": 24 },\n    { \"species\": \"gothita\", \"weight\": 3, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"solosis\", \"weight\": 3, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"poochyena\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"mightyena\", \"weight\": 2, \"min_level\": 22, \"max_level\": 40 },\n    { \"species\": \"nacli\", \"weight\": 4, \"min_level\": 8, \"max_level\": 24 },\n    { \"species\": \"shroodle\", \"weight\": 3, \"min_level\": 8, \"max_level\": 20 },\n    { \"species\": \"riolu\", \"weight\": 2, \"min_level\": 24, \"max_level\": 45 },\n    { \"species\": \"venipede\", \"weight\": 4, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"swinub\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"barboach\", \"weight\": 4, \"min_level\": 6, \"max_level\": 18 },\n    { \"species\": \"dwebble\", \"weight\": 4, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"bergmite\", \"weight\": 3, \"min_level\": 15, \"max_level\": 28 },\n    { \"species\": \"shelmet\", \"weight\": 3, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"teddiursa\", \"weight\": 3, \"min_level\": 12, \"max_level\": 28 },\n    { \"species\": \"inkay\", \"weight\": 3, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"rhyhorn\", \"weight\": 2, \"min_level\": 22, \"max_level\": 45 },\n    { \"species\": \"hippopotas\", \"weight\": 3, \"min_level\": 15, \"max_level\": 32 },\n    { \"species\": \"koffing\", \"weight\": 3, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"yamask\", \"weight\": 2, \"min_level\": 14, \"max_level\": 28 },\n    { \"species\": \"houndour\", \"weight\": 3, \"min_level\": 12, \"max_level\": 28 },\n    { \"species\": \"spinarak\", \"weight\": 4, \"min_level\": 4, \"max_level\": 20 },\n    { \"species\": \"zangoose\", \"weight\": 2, \"min_level\": 18, \"max_level\": 34 },\n    { \"species\": \"seviper\", \"weight\": 2, \"min_level\": 18, \"max_level\": 34 },\n    { \"species\": \"numel\", \"weight\": 4, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"clauncher\", \"weight\": 3, \"min_level\": 12, \"max_level\": 28 },\n    { \"species\": \"hatenna\", \"weight\": 3, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"rolycoly\", \"weight\": 4, \"min_level\": 6, \"max_level\": 22 },\n    { \"species\": \"lotad\", \"weight\": 4, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"arania\", \"weight\": 4, \"min_level\": 4, \"max_level\": 22 },\n    { \"species\": \"carvanha\", \"weight\": 3, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"bellsprout\", \"weight\": 4, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"oddish\", \"weight\": 4, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"feebas\", \"weight\": 2, \"min_level\": 5, \"max_level\": 20 },\n    { \"species\": \"yanma\", \"weight\": 3, \"min_level\": 15, \"max_level\": 32 },\n    { \"species\": \"marill\", \"weight\": 4, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"swablu\", \"weight\": 3, \"min_level\": 12, \"max_level\": 26 }\n    ]\n", RustlingSpotFamily.FLYING, "    [\n    { \"species\": \"murkrow\", \"weight\": 3, \"min_level\": 15, \"max_level\": 30 },\n    { \"species\": \"hoppip\", \"weight\": 5, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"pidgey\", \"weight\": 6, \"min_level\": 2, \"max_level\": 18 },\n    { \"species\": \"spearow\", \"weight\": 6, \"min_level\": 3, \"max_level\": 20 },\n    { \"species\": \"hoothoot\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"wingle\", \"weight\": 5, \"min_level\": 5, \"max_level\": 20 },\n    { \"species\": \"ducklett\", \"weight\": 4, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"noibat\", \"weight\": 2, \"min_level\": 22, \"max_level\": 45 },\n    { \"species\": \"tailow\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"starly\", \"weight\": 6, \"min_level\": 3, \"max_level\": 20 },\n    { \"species\": \"fletchling\", \"weight\": 6, \"min_level\": 2, \"max_level\": 18 },\n    { \"species\": \"delibird\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"farfetchd\", \"weight\": 2, \"min_level\": 18, \"max_level\": 38 },\n    { \"species\": \"rufflet\", \"weight\": 3, \"min_level\": 18, \"max_level\": 38 },\n    { \"species\": \"vullaby\", \"weight\": 3, \"min_level\": 18, \"max_level\": 40 },\n    { \"species\": \"yanma\", \"weight\": 4, \"min_level\": 12, \"max_level\": 28 },\n    { \"species\": \"natu\", \"weight\": 4, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"chatot\", \"weight\": 3, \"min_level\": 12, \"max_level\": 30 },\n    { \"species\": \"swablu\", \"weight\": 4, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"drifloon\", \"weight\": 3, \"min_level\": 12, \"max_level\": 26 },\n    { \"species\": \"trumbeak\", \"weight\": 2, \"min_level\": 25, \"max_level\": 45 },\n    { \"species\": \"pikipek\", \"weight\": 5, \"min_level\": 4, \"max_level\": 20 },\n    { \"species\": \"skarmory\", \"weight\": 1, \"min_level\": 35, \"max_level\": 65 },\n    { \"species\": \"tropius\", \"weight\": 2, \"min_level\": 28, \"max_level\": 50 },\n    { \"species\": \"hatenna\", \"weight\": 3, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"rookidee\", \"weight\": 6, \"min_level\": 3, \"max_level\": 18 },\n    { \"species\": \"corvisquire\", \"weight\": 3, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"bombirdier\", \"weight\": 1, \"min_level\": 35, \"max_level\": 60 },\n    { \"species\": \"squawkabilly\", \"weight\": 4, \"min_level\": 8, \"max_level\": 26 },\n    { \"species\": \"rowlet\", \"weight\": 4, \"min_level\": 6, \"max_level\": 24 },\n    { \"species\": \"dartrix\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"pidove\", \"weight\": 6, \"min_level\": 4, \"max_level\": 20 },\n    { \"species\": \"tranquill\", \"weight\": 3, \"min_level\": 18, \"max_level\": 40 },\n    { \"species\": \"combee\", \"weight\": 5, \"min_level\": 4, \"max_level\": 18 },\n    { \"species\": \"vespiquen\", \"weight\": 1, \"min_level\": 25, \"max_level\": 50 },\n    { \"species\": \"shuppet\", \"weight\": 3, \"min_level\": 14, \"max_level\": 28 },\n    { \"species\": \"misdreavus\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"pancham\", \"weight\": 3, \"min_level\": 12, \"max_level\": 28 },\n    { \"species\": \"hawlucha\", \"weight\": 2, \"min_level\": 25, \"max_level\": 45 },\n    { \"species\": \"gligar\", \"weight\": 3, \"min_level\": 16, \"max_level\": 32 },\n    { \"species\": \"scyther\", \"weight\": 2, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"archen\", \"weight\": 1, \"min_level\": 30, \"max_level\": 55 },\n    { \"species\": \"fomantis\", \"weight\": 4, \"min_level\": 6, \"max_level\": 20 },\n    { \"species\": \"litleo\", \"weight\": 3, \"min_level\": 10, \"max_level\": 26 },\n    { \"species\": \"sliggoo\", \"weight\": 2, \"min_level\": 28, \"max_level\": 50 },\n    { \"species\": \"golbat\", \"weight\": 3, \"min_level\": 20, \"max_level\": 40 },\n    { \"species\": \"oricorio\", \"weight\": 2, \"min_level\": 20, \"max_level\": 38 },\n    { \"species\": \"piplup\", \"weight\": 3, \"min_level\": 8, \"max_level\": 22 },\n    { \"species\": \"ducklett\", \"weight\": 3, \"min_level\": 10, \"max_level\": 24 },\n    { \"species\": \"sprigatito\", \"weight\": 3, \"min_level\": 10, \"max_level\": 22 },\n    { \"species\": \"togepi\", \"weight\": 4, \"min_level\": 5, \"max_level\": 20 },\n    { \"species\": \"togetic\", \"weight\": 2, \"min_level\": 20, \"max_level\": 45 },\n    { \"species\": \"fletchinder\", \"weight\": 3, \"min_level\": 18, \"max_level\": 36 },\n    { \"species\": \"dragonair\", \"weight\": 1, \"min_level\": 35, \"max_level\": 65 }\n    ]\n", RustlingSpotFamily.NETHERFLAMME, "[\n  { \"species\": \"slugma\",     \"weight\": 7, \"min_level\": 20, \"max_level\": 40 },\n  { \"species\": \"magby\",      \"weight\": 6, \"min_level\": 22, \"max_level\": 42 },\n  { \"species\": \"numel\",      \"weight\": 6, \"min_level\": 24, \"max_level\": 46 },\n  { \"species\": \"salandit\",   \"weight\": 6, \"min_level\": 24, \"max_level\": 46 },\n  { \"species\": \"sizzlipede\", \"weight\": 6, \"min_level\": 26, \"max_level\": 48 },\n  { \"species\": \"litleo\",     \"weight\": 5, \"min_level\": 24, \"max_level\": 46 },\n  { \"species\": \"houndour\",   \"weight\": 5, \"min_level\": 26, \"max_level\": 48 },\n  { \"species\": \"growlithe\",  \"weight\": 4, \"min_level\": 28, \"max_level\": 52 },\n  { \"species\": \"vulpix\",     \"weight\": 4, \"min_level\": 28, \"max_level\": 52 },\n  { \"species\": \"heatmor\",    \"weight\": 4, \"min_level\": 30, \"max_level\": 55 },\n  { \"species\": \"torkoal\",    \"weight\": 4, \"min_level\": 30, \"max_level\": 55 },\n  { \"species\": \"charcadet\",  \"weight\": 3, \"min_level\": 32, \"max_level\": 60 },\n  { \"species\": \"flareon\",    \"weight\": 2, \"min_level\": 34, \"max_level\": 58 },\n  { \"species\": \"pansear\",    \"weight\": 4, \"min_level\": 22, \"max_level\": 42 },\n  { \"species\": \"darumaka\",   \"weight\": 4, \"min_level\": 26, \"max_level\": 48 },\n  { \"species\": \"turtonator\", \"weight\": 3, \"min_level\": 34, \"max_level\": 60 },\n  { \"species\": \"larvitar\",   \"weight\": 1, \"min_level\": 38, \"max_level\": 65 },\n  { \"species\": \"rolycoly\",   \"weight\": 3, \"min_level\": 26, \"max_level\": 48 },\n  { \"species\": \"coalossal\",  \"weight\": 1, \"min_level\": 50, \"max_level\": 65 },\n  { \"species\": \"charmander\", \"weight\": 2, \"min_level\": 28, \"max_level\": 48 },\n  { \"species\": \"torchic\",    \"weight\": 2, \"min_level\": 28, \"max_level\": 48 },\n  { \"species\": \"fuecoco\",    \"weight\": 2, \"min_level\": 28, \"max_level\": 48 }\n]", RustlingSpotFamily.SOULFLAME, "[\n  { \"species\": \"litwick\",   \"weight\": 7, \"min_level\": 22, \"max_level\": 42 },\n  { \"species\": \"duskull\",   \"weight\": 6, \"min_level\": 22, \"max_level\": 42 },\n  { \"species\": \"shuppet\",   \"weight\": 6, \"min_level\": 20, \"max_level\": 40 },\n  { \"species\": \"gastly\",    \"weight\": 6, \"min_level\": 24, \"max_level\": 44 },\n  { \"species\": \"drifloon\",  \"weight\": 5, \"min_level\": 24, \"max_level\": 44 },\n  { \"species\": \"sinistea\",  \"weight\": 5, \"min_level\": 26, \"max_level\": 46 },\n  { \"species\": \"yamask\",    \"weight\": 5, \"min_level\": 26, \"max_level\": 48 },\n  { \"species\": \"zorua\",     \"weight\": 4, \"min_level\": 28, \"max_level\": 50 },\n  { \"species\": \"murkrow\",   \"weight\": 4, \"min_level\": 26, \"max_level\": 48 },\n  { \"species\": \"sableye\",   \"weight\": 3, \"min_level\": 30, \"max_level\": 55 },\n  { \"species\": \"mawile\",    \"weight\": 3, \"min_level\": 30, \"max_level\": 55 },\n  { \"species\": \"charcadet\", \"weight\": 4, \"min_level\": 30, \"max_level\": 58 },\n  { \"species\": \"slugma\",    \"weight\": 4, \"min_level\": 26, \"max_level\": 48 },\n  { \"species\": \"magby\",     \"weight\": 3, \"min_level\": 28, \"max_level\": 52 },\n  { \"species\": \"salandit\",  \"weight\": 4, \"min_level\": 28, \"max_level\": 52 },\n  { \"species\": \"vulpix\",    \"weight\": 3, \"min_level\": 30, \"max_level\": 54 },\n  { \"species\": \"baltoy\",    \"weight\": 4, \"min_level\": 26, \"max_level\": 46 },\n  { \"species\": \"golett\",    \"weight\": 3, \"min_level\": 30, \"max_level\": 55 },\n  { \"species\": \"absol\",     \"weight\": 2, \"min_level\": 36, \"max_level\": 62 },\n  { \"species\": \"mimikyu\",   \"weight\": 1, \"min_level\": 38, \"max_level\": 65 },\n  { \"species\": \"spiritomb\", \"weight\": 1, \"min_level\": 40, \"max_level\": 65 }\n]");

    private PokemonPoolService() {
    }

    public static void ensureDefaultsExist() {
        PokemonPoolService.createDefaults();
    }

    public static PokemonEntry pickRandom(ServerLevel level, RustlingSpot spot, RandomSource random) {
        PokemonPoolService.ensureLoaded();
        boolean enforceTypes = RustlingSpotsPokemonConfig.POKEMON_SPAWN.typedSpawnRules();
        List<PokemonEntry> candidates = ENTRIES.stream().filter(entry -> !enforceTypes || entry.matchesFamily(spot.getFamily())).toList();
        if (candidates.isEmpty()) {
            if (RustlingSpotsServerConfig.GENERAL.loggingEnabled()) {
                LOGGER.debug("No configured Pok\u00e9mon entries for family {}", (Object)spot.getFamily());
            }
            return null;
        }
        int totalWeight = candidates.stream().mapToInt(PokemonEntry::weight).sum();
        if (totalWeight <= 0) {
            if (RustlingSpotsServerConfig.GENERAL.loggingEnabled()) {
                LOGGER.debug("Configured Pok\u00e9mon pool had no weight for family {}", (Object)spot.getFamily());
            }
            return null;
        }
        int roll = random.nextInt(totalWeight);
        int accumulator = 0;
        for (PokemonEntry entry2 : candidates) {
            if (roll >= (accumulator += entry2.weight())) continue;
            return entry2;
        }
        return candidates.get(candidates.size() - 1);
    }

    private static void ensureLoaded() {
        if (LOADED.getAndSet(true)) {
            return;
        }
        PokemonPoolService.createDefaults();
        ENTRIES.clear();
        for (RustlingSpotFamily family : RustlingSpotFamily.values()) {
            Path file = FAMILY_DIR.resolve(family.name().toLowerCase() + ".json");
            ENTRIES.addAll(PokemonPoolService.readPool(file, family));
        }
        if (ENTRIES.isEmpty()) {
            LOGGER.warn("Pokemon pool configuration is empty; rustling spots will not spawn Pok\u00e9mon.");
        }
    }

    private static void createDefaults() {
        try {
            Files.createDirectories(FAMILY_DIR, new FileAttribute[0]);
            for (RustlingSpotFamily family : RustlingSpotFamily.values()) {
                Path path = FAMILY_DIR.resolve(family.name().toLowerCase() + ".json");
                if (!Files.notExists(path, new LinkOption[0])) continue;
                Files.writeString(path, (CharSequence)DEFAULT_FAMILY.getOrDefault((Object)family, "[]"), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create default pokemon pool configuration", (Throwable)e);
        }
    }

    private static List<PokemonEntry> readPool(Path path, RustlingSpotFamily familyTag) {
        ArrayList<PokemonEntry> parsed = new ArrayList<PokemonEntry>();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            PokemonEntryData[] data = (PokemonEntryData[])GSON.fromJson((Reader)reader, PokemonEntryData[].class);
            if (data != null) {
                for (PokemonEntryData entry : data) {
                    PokemonPoolService.toEntry(entry, familyTag).ifPresent(parsed::add);
                }
            }
        }
        catch (JsonParseException | IOException e) {
            LOGGER.warn("Failed to read pokemon pool from {}", (Object)path, (Object)e);
        }
        return parsed;
    }

    private static Optional<PokemonEntry> toEntry(PokemonEntryData data, RustlingSpotFamily familyTag) {
        if (data == null || data.species == null || data.weight <= 0) {
            return Optional.empty();
        }
        String species = data.species.trim();
        if (species.isEmpty()) {
            LOGGER.warn("Invalid Pok\u00e9mon species '{}' in pokemon pools", (Object)data.species);
            return Optional.empty();
        }
        EnumSet<RustlingSpotFamily> families = EnumSet.noneOf(RustlingSpotFamily.class);
        if (data.families != null) {
            for (String name : data.families) {
                try {
                    families.add(RustlingSpotFamily.valueOf(name));
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Unknown family '{}' for Pok\u00e9mon entry {}", (Object)name, (Object)species);
                }
            }
        } else if (familyTag != null) {
            families.add(familyTag);
        }
        Integer minLevel = data.min_level != null ? Integer.valueOf(Math.max(1, data.min_level)) : null;
        Integer maxLevel = data.max_level != null ? Integer.valueOf(Math.max(1, data.max_level)) : null;
        Boolean shiny = data.shiny;
        Double shinyChance = data.shinyChance;
        return Optional.of(new PokemonEntry(species, data.weight, minLevel, maxLevel, shiny, shinyChance, families));
    }

    public record PokemonEntry(String species, int weight, Integer minLevel, Integer maxLevel, Boolean shiny, Double shinyChance, Set<RustlingSpotFamily> families) {
        public boolean matchesFamily(RustlingSpotFamily family) {
            return this.families == null || this.families.isEmpty() || this.families.contains((Object)family);
        }

        public int resolvedMinLevel() {
            int floor = RustlingSpotsPokemonConfig.POKEMON_SPAWN.minLevel();
            int ceiling = RustlingSpotsPokemonConfig.POKEMON_SPAWN.maxLevel();
            int configuredMin = Math.max(1, Objects.requireNonNullElse(this.minLevel, floor));
            int configuredMax = Math.max(1, Objects.requireNonNullElse(this.maxLevel, ceiling));
            if (configuredMax < floor || configuredMin > ceiling) {
                return floor;
            }
            int boundedMin = Math.max(floor, Math.min(configuredMin, configuredMax));
            return Math.min(boundedMin, ceiling);
        }

        public int resolvedMaxLevel() {
            int floor = RustlingSpotsPokemonConfig.POKEMON_SPAWN.minLevel();
            int ceiling = RustlingSpotsPokemonConfig.POKEMON_SPAWN.maxLevel();
            int configuredMin = Math.max(1, Objects.requireNonNullElse(this.minLevel, floor));
            int configuredMax = Math.max(1, Objects.requireNonNullElse(this.maxLevel, ceiling));
            if (configuredMax < floor || configuredMin > ceiling) {
                return ceiling;
            }
            int boundedMax = Math.min(ceiling, Math.max(configuredMin, configuredMax));
            return Math.max(boundedMax, floor);
        }
    }

    private static class PokemonEntryData {
        String species;
        int weight = 1;
        Integer min_level;
        Integer max_level;
        Boolean shiny;
        Double shinyChance;
        List<String> families;

        private PokemonEntryData() {
        }
    }
}

