/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LootPoolService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LootPoolService.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path BASE = FMLPaths.CONFIGDIR.get().resolve("rustlingspots");
    private static final Path LOOT_DIR = BASE.resolve("loot");
    private static final Path GLOBAL_LOOT_FILE = LOOT_DIR.resolve("global_loot.json");
    private static final Path FAMILY_DIR = LOOT_DIR.resolve("families");
    private static final AtomicBoolean LOADED = new AtomicBoolean(false);
    private static final Map<RustlingSpotFamily, List<LootEntry>> POOLS = new EnumMap<RustlingSpotFamily, List<LootEntry>>(RustlingSpotFamily.class);
    private static final String DEFAULT_GLOBAL = "[\n  { \"item\": \"cobblemon:oran_berry\", \"min\": 1, \"max\": 3, \"weight\": 4 },\n  { \"item\": \"minecraft:stick\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"cobblemon:pecha_berry\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:cheri_berry\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:rawst_berry\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:aspear_berry\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:black_apricorn\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:red_apricorn\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:yellow_apricorn\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:exp_candy_xs\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n";
    private static final Map<RustlingSpotFamily, String> DEFAULT_FAMILY_LOOT = Map.of(RustlingSpotFamily.GRASS, "[\n  { \"item\": \"cobblemon:revive\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"minecraft:wheat_seeds\", \"min\": 2, \"max\": 6, \"weight\": 3 },\n  { \"item\": \"minecraft:beetroot_seeds\", \"min\": 1, \"max\": 4, \"weight\": 3 },\n  { \"item\": \"minecraft:melon_seeds\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"minecraft:pumpkin_seeds\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"minecraft:sugar_cane\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"minecraft:feather\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"minecraft:flower_pot\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:black_apricorn_seed\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:red_apricorn_seed\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:yellow_apricorn_seed\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"cobblemon:green_apricorn_seed\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"cobblemon:oran_berry\", \"min\": 1, \"max\": 3, \"weight\": 4 },\n  { \"item\": \"cobblemon:sitrus_berry\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:lum_berry\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:vivichoke\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:medicinal_leek\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:energy_root\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"minecraft:apple\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"minecraft:dandelion\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"minecraft:azure_bluet\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"minecraft:allium\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:nest_ball\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:grass_gem\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:exp_candy_xs\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n", RustlingSpotFamily.LEAVES, "[\n  { \"item\": \"cobblemon:exp_candy_s\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"minecraft:stick\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"minecraft:oak_sapling\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"minecraft:birch_sapling\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"minecraft:jungle_sapling\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"minecraft:acacia_sapling\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"minecraft:apple\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"minecraft:glow_berries\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"minecraft:honeycomb\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"minecraft:oak_leaves\", \"min\": 1, \"max\": 3, \"weight\": 1 },\n  { \"item\": \"cobblemon:red_apricorn\", \"min\": 1, \"max\": 3, \"weight\": 4 },\n  { \"item\": \"cobblemon:yellow_apricorn\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:green_apricorn\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:blue_apricorn\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:red_mint_leaf\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:blue_mint_leaf\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:green_mint_leaf\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:white_mint_leaf\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"cobblemon:cheri_berry\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:pecha_berry\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:pinap_berry\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:friend_ball\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:revival_herb\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n", RustlingSpotFamily.WATER, "[\n  { \"item\": \"cobblemon:pearl\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"minecraft:prismarine_shard\", \"min\": 1, \"max\": 3, \"weight\": 1 },\n  { \"item\": \"minecraft:cod\", \"min\": 2, \"max\": 5, \"weight\": 4 },\n  { \"item\": \"minecraft:salmon\", \"min\": 2, \"max\": 5, \"weight\": 4 },\n  { \"item\": \"minecraft:tropical_fish\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"minecraft:kelp\", \"min\": 2, \"max\": 6, \"weight\": 4 },\n  { \"item\": \"minecraft:seagrass\", \"min\": 1, \"max\": 4, \"weight\": 3 },\n  { \"item\": \"cobblemon:razz_berry\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:passho_berry\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:water_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:net_ball\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:dive_ball\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:potion\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:antidote\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:fossilized_fish\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n", RustlingSpotFamily.SAND, "[\n  { \"item\": \"minecraft:feather\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"minecraft:glass_bottle\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"minecraft:sand\", \"min\": 3, \"max\": 8, \"weight\": 4 },\n  { \"item\": \"minecraft:red_sand\", \"min\": 2, \"max\": 6, \"weight\": 3 },\n  { \"item\": \"minecraft:cactus\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"minecraft:dead_bush\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"minecraft:bone\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:razz_berry\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:figy_berry\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:fire_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:ground_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:rock_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:quick_ball\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:root_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:claw_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:jaw_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n", RustlingSpotFamily.SNOW, "[\n  { \"item\": \"minecraft:snowball\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"minecraft:blue_ice\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"minecraft:ice\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"minecraft:packed_ice\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:aspear_berry\", \"min\": 1, \"max\": 3, \"weight\": 4 },\n  { \"item\": \"cobblemon:leppa_berry\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:lum_berry\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"minecraft:cooked_mutton\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"minecraft:cooked_beef\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:ice_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:potion\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:full_heal\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:ice_stone\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n", RustlingSpotFamily.CAVE, "[\n  { \"item\": \"minecraft:iron_ingot\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"minecraft:coal\", \"min\": 3, \"max\": 8, \"weight\": 5 },\n  { \"item\": \"minecraft:raw_iron\", \"min\": 1, \"max\": 4, \"weight\": 4 },\n  { \"item\": \"minecraft:raw_copper\", \"min\": 1, \"max\": 4, \"weight\": 4 },\n  { \"item\": \"cobblemon:tumblestone\", \"min\": 1, \"max\": 4, \"weight\": 5 },\n  { \"item\": \"cobblemon:black_tumblestone\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:sky_tumblestone\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"minecraft:torch\", \"min\": 2, \"max\": 6, \"weight\": 4 },\n  { \"item\": \"minecraft:bread\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:oran_berry\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:sitrus_berry\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:remedy\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:antidote\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:paralyze_heal\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:great_ball\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:dusk_ball\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:rock_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:ground_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:exp_candy_xs\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:helix_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:dome_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:skull_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:armor_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"minecraft:iron_ingot\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"minecraft:coal\", \"min\": 3, \"max\": 8, \"weight\": 5 },\n  { \"item\": \"minecraft:raw_iron\", \"min\": 1, \"max\": 4, \"weight\": 4 },\n  { \"item\": \"minecraft:raw_copper\", \"min\": 1, \"max\": 4, \"weight\": 4 },\n  { \"item\": \"cobblemon:tumblestone\", \"min\": 1, \"max\": 4, \"weight\": 5 },\n  { \"item\": \"cobblemon:black_tumblestone\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:sky_tumblestone\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"minecraft:torch\", \"min\": 2, \"max\": 6, \"weight\": 4 },\n  { \"item\": \"minecraft:bread\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:oran_berry\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:sitrus_berry\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:remedy\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:antidote\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:paralyze_heal\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:great_ball\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:dusk_ball\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:rock_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:ground_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:exp_candy_xs\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:helix_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:dome_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:skull_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:armor_fossil\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"minecraft:iron_nugget\", \"min\": 3, \"max\": 8, \"weight\": 3 },\n  { \"item\": \"minecraft:gold_nugget\", \"min\": 2, \"max\": 5, \"weight\": 2 },\n  { \"item\": \"minecraft:raw_gold\", \"min\": 1, \"max\": 3, \"weight\": 1 },\n  { \"item\": \"minecraft:redstone\", \"min\": 2, \"max\": 6, \"weight\": 2 },\n  { \"item\": \"minecraft:lapis_lazuli\", \"min\": 2, \"max\": 5, \"weight\": 2 },\n  { \"item\": \"minecraft:amethyst_shard\", \"min\": 1, \"max\": 3, \"weight\": 1 },\n  { \"item\": \"minecraft:copper_ingot\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"minecraft:flint\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"minecraft:arrow\", \"min\": 2, \"max\": 6, \"weight\": 2 },\n  { \"item\": \"minecraft:bone\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"minecraft:string\", \"min\": 1, \"max\": 3, \"weight\": 2 },\n  { \"item\": \"minecraft:rail\", \"min\": 3, \"max\": 8, \"weight\": 2 },\n  { \"item\": \"minecraft:stone_pickaxe\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n", RustlingSpotFamily.FLYING, "[\n  { \"item\": \"minecraft:feather\", \"min\": 2, \"max\": 6, \"weight\": 5 },\n  { \"item\": \"minecraft:ghast_tear\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"minecraft:phantom_membrane\", \"min\": 1, \"max\": 2, \"weight\": 1 },\n  { \"item\": \"minecraft:string\", \"min\": 1, \"max\": 4, \"weight\": 3 },\n  { \"item\": \"minecraft:paper\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:health_feather\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:muscle_feather\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:resist_feather\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:genius_feather\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:clever_feather\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:swift_feather\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:flying_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:razz_berry\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:leppa_berry\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"minecraft:bread\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"minecraft:cooked_chicken\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 3, \"weight\": 3 },\n  { \"item\": \"cobblemon:great_ball\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:quick_ball\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:potion\", \"min\": 1, \"max\": 2, \"weight\": 2 },\n  { \"item\": \"cobblemon:full_heal\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n", RustlingSpotFamily.NETHERFLAMME, "[\n  { \"item\": \"minecraft:magma_cream\", \"min\": 1, \"max\": 3, \"weight\": 5 },\n  { \"item\": \"minecraft:blaze_powder\", \"min\": 1, \"max\": 2, \"weight\": 4 },\n  { \"item\": \"minecraft:coal\", \"min\": 2, \"max\": 6, \"weight\": 4 },\n  { \"item\": \"minecraft:fire_charge\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"minecraft:basalt\", \"min\": 2, \"max\": 6, \"weight\": 4 },\n  { \"item\": \"minecraft:blackstone\", \"min\": 2, \"max\": 6, \"weight\": 4 },\n  { \"item\": \"minecraft:gold_nugget\", \"min\": 2, \"max\": 6, \"weight\": 3 },\n  { \"item\": \"cobblemon:razz_berry\", \"min\": 1, \"max\": 3, \"weight\": 4 },\n  { \"item\": \"cobblemon:figy_berry\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:fire_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:great_ball\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:potion\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:burn_heal\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:exp_candy_xs\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:fire_stone\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n", RustlingSpotFamily.SOULFLAME, "[\n  { \"item\": \"minecraft:soul_sand\", \"min\": 2, \"max\": 6, \"weight\": 5 },\n  { \"item\": \"minecraft:soul_soil\", \"min\": 2, \"max\": 6, \"weight\": 5 },\n  { \"item\": \"minecraft:soul_torch\", \"min\": 1, \"max\": 3, \"weight\": 4 },\n  { \"item\": \"minecraft:bone\", \"min\": 1, \"max\": 3, \"weight\": 4 },\n  { \"item\": \"minecraft:coal\", \"min\": 2, \"max\": 5, \"weight\": 3 },\n  { \"item\": \"minecraft:echo_shard\", \"min\": 1, \"max\": 1, \"weight\": 1 },\n  { \"item\": \"cobblemon:spell_tag\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:ghost_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:dark_gem\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:razz_berry\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:kasib_berry\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:poke_ball\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:dusk_ball\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:potion\", \"min\": 1, \"max\": 2, \"weight\": 3 },\n  { \"item\": \"cobblemon:full_heal\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:exp_candy_xs\", \"min\": 1, \"max\": 1, \"weight\": 2 },\n  { \"item\": \"cobblemon:dusk_stone\", \"min\": 1, \"max\": 1, \"weight\": 1 }\n]\n");

    private LootPoolService() {
    }

    public static void ensureDefaultsExist() {
        LootPoolService.createDefaults();
    }

    public static ItemStack pickLoot(RustlingSpotFamily family, RandomSource random) {
        LootPoolService.ensureLoaded();
        List pool = POOLS.getOrDefault((Object)family, List.of());
        if (pool.isEmpty()) {
            if (RustlingSpotsServerConfig.GENERAL.loggingEnabled()) {
                LOGGER.debug("No configured loot entries for family {}", (Object)family);
            }
            return ItemStack.EMPTY;
        }
        int totalWeight = pool.stream().mapToInt(LootEntry::weight).sum();
        if (totalWeight <= 0) {
            return ItemStack.EMPTY;
        }
        int roll = random.nextInt(totalWeight);
        int accumulator = 0;
        for (LootEntry entry : pool) {
            if (roll >= (accumulator += entry.weight())) continue;
            int amount = entry.min() + random.nextInt(entry.max() - entry.min() + 1);
            ItemStack stack = new ItemStack((ItemLike)entry.item(), amount);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static void ensureLoaded() {
        if (LOADED.getAndSet(true)) {
            return;
        }
        LootPoolService.createDefaults();
        POOLS.clear();
        List<LootEntry> global = LootPoolService.readLootFile(GLOBAL_LOOT_FILE, "global loot");
        for (RustlingSpotFamily family : RustlingSpotFamily.values()) {
            ArrayList<LootEntry> entries = new ArrayList<LootEntry>(global);
            Path familyFile = FAMILY_DIR.resolve(family.name().toLowerCase() + ".json");
            entries.addAll(LootPoolService.readLootFile(familyFile, family.name() + " loot"));
            if (entries.isEmpty()) continue;
            POOLS.put(family, entries);
        }
    }

    private static void createDefaults() {
        try {
            Files.createDirectories(FAMILY_DIR, new FileAttribute[0]);
            if (Files.notExists(GLOBAL_LOOT_FILE, new LinkOption[0])) {
                Files.writeString(GLOBAL_LOOT_FILE, (CharSequence)DEFAULT_GLOBAL, new OpenOption[0]);
            }
            for (RustlingSpotFamily family : RustlingSpotFamily.values()) {
                Path file = FAMILY_DIR.resolve(family.name().toLowerCase() + ".json");
                if (!Files.notExists(file, new LinkOption[0])) continue;
                String template = DEFAULT_FAMILY_LOOT.getOrDefault((Object)family, "[]");
                Files.writeString(file, (CharSequence)template, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create default loot configuration", (Throwable)e);
        }
    }

    private static List<LootEntry> readLootFile(Path path, String label) {
        ArrayList<LootEntry> parsed = new ArrayList<LootEntry>();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            LootEntryData[] data = (LootEntryData[])GSON.fromJson((Reader)reader, LootEntryData[].class);
            if (data != null) {
                for (LootEntryData lootData : data) {
                    LootPoolService.toEntry(lootData).ifPresent(parsed::add);
                }
            }
        }
        catch (JsonParseException | IOException e) {
            LOGGER.warn("Failed to read {} from {}", new Object[]{label, path, e});
        }
        return parsed;
    }

    private static Optional<LootEntry> toEntry(LootEntryData data) {
        if (data == null || data.item == null || data.weight <= 0) {
            return Optional.empty();
        }
        ResourceLocation id = ResourceLocation.tryParse((String)data.item);
        if (id == null) {
            LOGGER.warn("Invalid item id '{}' in loot configuration", (Object)data.item);
            return Optional.empty();
        }
        Item item = BuiltInRegistries.ITEM.getOptional(id).orElse(null);
        if (item == null) {
            LOGGER.warn("Unknown item '{}' in loot configuration", (Object)id);
            return Optional.empty();
        }
        int min = Math.max(1, data.min);
        int max = Math.max(min, data.max);
        return Optional.of(new LootEntry(item, min, max, data.weight));
    }

    private record LootEntry(Item item, int min, int max, int weight) {
    }

    private static class LootEntryData {
        String item;
        int min = 1;
        int max = 1;
        int weight = 1;

        private LootEntryData() {
        }
    }
}

