/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public enum BiomeGroup {
    FOREST,
    PLAINS,
    SWAMP,
    MOUNTAIN,
    SNOWY,
    DESERT,
    RIVER,
    OCEAN,
    OTHER;

    private static final TagKey<Biome> FOREST_TAG;
    private static final TagKey<Biome> PLAINS_TAG;
    private static final TagKey<Biome> SWAMP_TAG;
    private static final TagKey<Biome> MOUNTAIN_TAG;
    private static final TagKey<Biome> SNOWY_TAG;
    private static final TagKey<Biome> DESERT_TAG;
    private static final TagKey<Biome> RIVER_TAG;
    private static final TagKey<Biome> OCEAN_TAG;

    public static BiomeGroup fromBiome(Holder<Biome> biome) {
        if (biome.is(FOREST_TAG)) {
            return FOREST;
        }
        if (biome.is(PLAINS_TAG)) {
            return PLAINS;
        }
        if (biome.is(SWAMP_TAG)) {
            return SWAMP;
        }
        if (biome.is(MOUNTAIN_TAG)) {
            return MOUNTAIN;
        }
        if (biome.is(SNOWY_TAG)) {
            return SNOWY;
        }
        if (biome.is(DESERT_TAG)) {
            return DESERT;
        }
        if (biome.is(RIVER_TAG)) {
            return RIVER;
        }
        if (biome.is(OCEAN_TAG)) {
            return OCEAN;
        }
        return OTHER;
    }

    static {
        FOREST_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"minecraft:is_forest"));
        PLAINS_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"minecraft:is_plains"));
        SWAMP_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"minecraft:is_swamp"));
        MOUNTAIN_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"minecraft:is_mountain"));
        SNOWY_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"minecraft:is_snowy"));
        DESERT_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"minecraft:is_desert"));
        RIVER_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"minecraft:is_river"));
        OCEAN_TAG = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"minecraft:is_ocean"));
    }
}

