/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.registry;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class RustlingSoundEvents {
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"rustlingspots");
    private static final DeferredHolder<SoundEvent, SoundEvent> GRASS_AMBIENT = RustlingSoundEvents.register("spot/ambient/grass");
    private static final DeferredHolder<SoundEvent, SoundEvent> SAND_AMBIENT = RustlingSoundEvents.register("spot/ambient/sand");
    private static final DeferredHolder<SoundEvent, SoundEvent> WATER_AMBIENT = RustlingSoundEvents.register("spot/ambient/water");
    private static final DeferredHolder<SoundEvent, SoundEvent> SNOW_AMBIENT = RustlingSoundEvents.register("spot/ambient/snow");
    private static final DeferredHolder<SoundEvent, SoundEvent> LEAVES_AMBIENT = RustlingSoundEvents.register("spot/ambient/leaves");
    private static final DeferredHolder<SoundEvent, SoundEvent> CAVE_AMBIENT = RustlingSoundEvents.register("spot/ambient/cave");
    private static final DeferredHolder<SoundEvent, SoundEvent> NETHERFLAMME_AMBIENT = RustlingSoundEvents.register("spot/ambient/netherflamme");
    private static final DeferredHolder<SoundEvent, SoundEvent> SOULFLAME_AMBIENT = RustlingSoundEvents.register("spot/ambient/soulflame");
    private static final DeferredHolder<SoundEvent, SoundEvent> FLYING_AMBIENT = RustlingSoundEvents.register("spot/ambient/flying");
    private static final List<DeferredHolder<SoundEvent, SoundEvent>> AMBIENT_VARIANTS = List.of(GRASS_AMBIENT, SAND_AMBIENT, WATER_AMBIENT, SNOW_AMBIENT, LEAVES_AMBIENT, CAVE_AMBIENT, NETHERFLAMME_AMBIENT, SOULFLAME_AMBIENT, FLYING_AMBIENT);
    public static final DeferredHolder<SoundEvent, SoundEvent> POKEMON_SPAWN = RustlingSoundEvents.register("spot/pokemon_spawn");
    public static final DeferredHolder<SoundEvent, SoundEvent> ITEM_REWARD = RustlingSoundEvents.register("spot/item_reward");
    private static final EnumMap<RustlingSpotFamily, DeferredHolder<SoundEvent, SoundEvent>> AMBIENT_BY_FAMILY = new EnumMap<RustlingSpotFamily, DeferredHolder<SoundEvent, SoundEvent>>(Map.of(RustlingSpotFamily.GRASS, GRASS_AMBIENT, RustlingSpotFamily.SAND, SAND_AMBIENT, RustlingSpotFamily.WATER, WATER_AMBIENT, RustlingSpotFamily.SNOW, SNOW_AMBIENT, RustlingSpotFamily.LEAVES, LEAVES_AMBIENT, RustlingSpotFamily.CAVE, CAVE_AMBIENT, RustlingSpotFamily.NETHERFLAMME, NETHERFLAMME_AMBIENT, RustlingSpotFamily.SOULFLAME, SOULFLAME_AMBIENT, RustlingSpotFamily.FLYING, FLYING_AMBIENT));

    private RustlingSoundEvents() {
    }

    public static void register(IEventBus bus) {
        SOUND_EVENTS.register(bus);
    }

    public static DeferredHolder<SoundEvent, SoundEvent> ambientVariant(int index) {
        if (index < 0 || index >= AMBIENT_VARIANTS.size()) {
            return AMBIENT_VARIANTS.get(0);
        }
        return AMBIENT_VARIANTS.get(index);
    }

    public static int indexForFamily(RustlingSpotFamily family) {
        DeferredHolder<SoundEvent, SoundEvent> holder = AMBIENT_BY_FAMILY.get((Object)family);
        if (holder == null) {
            return 0;
        }
        return AMBIENT_VARIANTS.indexOf(holder);
    }

    public static int ambientVariantCount() {
        return AMBIENT_VARIANTS.size();
    }

    private static DeferredHolder<SoundEvent, SoundEvent> register(String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rustlingspots", (String)path);
        return SOUND_EVENTS.register(path, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)id));
    }
}

