/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.network.packet;

import java.util.UUID;
import net.levelscraft7.rustlingspots.client.RustlingSpotClientHandler;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RustlingSpotSpawnPacket(UUID id, BlockPos pos, RustlingSpotFamily family, int ambientVariant) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RustlingSpotSpawnPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"rustlingspots", (String)"spot_spawn"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RustlingSpotSpawnPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> RustlingSpotSpawnPacket.encode(buf, packet), RustlingSpotSpawnPacket::decode);

    public RustlingSpotSpawnPacket(RustlingSpot spot) {
        this(spot.getId(), spot.getPosition(), spot.getFamily(), spot.getAmbientVariant());
    }

    public static void encode(RegistryFriendlyByteBuf buf, RustlingSpotSpawnPacket packet) {
        buf.writeUUID(packet.id);
        buf.writeBlockPos(packet.pos);
        buf.writeEnum((Enum)packet.family);
        buf.writeVarInt(packet.ambientVariant);
    }

    public static RustlingSpotSpawnPacket decode(RegistryFriendlyByteBuf buf) {
        UUID id = buf.readUUID();
        BlockPos pos = buf.readBlockPos();
        RustlingSpotFamily family = (RustlingSpotFamily)buf.readEnum(RustlingSpotFamily.class);
        int variant = buf.readVarInt();
        return new RustlingSpotSpawnPacket(id, pos, family, variant);
    }

    public static void handle(RustlingSpotSpawnPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> RustlingSpotClientHandler.handleSpawn(packet));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

