/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.network.packet;

import java.util.UUID;
import net.levelscraft7.rustlingspots.client.RustlingSpotClientHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RustlingSpotRemovePacket(UUID id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RustlingSpotRemovePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"rustlingspots", (String)"spot_remove"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RustlingSpotRemovePacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> RustlingSpotRemovePacket.encode(buf, packet), RustlingSpotRemovePacket::decode);

    public static void encode(RegistryFriendlyByteBuf buf, RustlingSpotRemovePacket packet) {
        buf.writeUUID(packet.id);
    }

    public static RustlingSpotRemovePacket decode(RegistryFriendlyByteBuf buf) {
        return new RustlingSpotRemovePacket(buf.readUUID());
    }

    public static void handle(RustlingSpotRemovePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> RustlingSpotClientHandler.handleRemove(packet.id()));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

