/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.config;

import java.util.EnumMap;
import java.util.Map;
import net.levelscraft7.rustlingspots.config.ConfigPathHelper;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class RustlingSpotsFamilySpawnConfig {
    public static final Families FAMILIES;
    public static final ModConfigSpec SPEC;

    private RustlingSpotsFamilySpawnConfig() {
    }

    public static void register(ModLoadingContext context) {
        context.getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SPEC, ConfigPathHelper.ensurePath("rustlingspots/rustlingspots-families.toml"));
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        FAMILIES = new Families(builder);
        SPEC = builder.build();
    }

    public static final class Families {
        private final Map<RustlingSpotFamily, ModConfigSpec.DoubleValue> familyRates = new EnumMap<RustlingSpotFamily, ModConfigSpec.DoubleValue>(RustlingSpotFamily.class);

        private Families(ModConfigSpec.Builder builder) {
            builder.comment("Spawn rate multipliers per rustling spot family (0.0 disables, 1.0 is default)").push("families");
            for (RustlingSpotFamily family : RustlingSpotFamily.values()) {
                double defaultRate = family == RustlingSpotFamily.FLYING ? 0.2 : 1.0;
                this.familyRates.put(family, builder.comment("Spawn rate multiplier for " + family.name().toLowerCase()).defineInRange(family.name().toLowerCase() + "_spawn_rate", defaultRate, 0.0, 1.0));
            }
            builder.pop();
        }

        public double spawnRate(RustlingSpotFamily family) {
            double rate = (Double)this.familyRates.get((Object)family).get();
            return Math.max(0.0, Math.min(1.0, rate));
        }
    }
}

