/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.config;

import net.levelscraft7.rustlingspots.config.ConfigPathHelper;
import net.minecraft.util.Mth;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class RustlingSpotsClientConfig {
    public static final Visual VISUAL;
    public static final ModConfigSpec SPEC;

    private RustlingSpotsClientConfig() {
    }

    public static void register(ModLoadingContext context) {
        context.getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, ConfigPathHelper.ensurePath("rustlingspots/rustlingspots-client.toml"));
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        VISUAL = new Visual(builder);
        SPEC = builder.build();
    }

    public static final class Visual {
        private final ModConfigSpec.DoubleValue shadowOpacity;
        private final ModConfigSpec.DoubleValue waterShadowOpacity;

        private Visual(ModConfigSpec.Builder builder) {
            builder.comment("Client visuals for Rustling Spots").push("visual");
            this.shadowOpacity = builder.comment("Opacity multiplier for the rustling spot shadow overlay (0 = invisible, 1 = opaque)").defineInRange("shadow_opacity", 0.85, 0.0, 1.0);
            this.waterShadowOpacity = builder.comment("Additional opacity multiplier applied when the spot or camera is underwater").defineInRange("water_shadow_opacity", 1.0, 0.0, 2.0);
            builder.pop();
        }

        public float shadowOpacity() {
            return Mth.clamp((float)((Double)this.shadowOpacity.get()).floatValue(), (float)0.0f, (float)1.0f);
        }

        public float waterShadowOpacity() {
            return Mth.clamp((float)((Double)this.waterShadowOpacity.get()).floatValue(), (float)0.0f, (float)2.0f);
        }
    }
}

