/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigPathHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigPathHelper.class);

    private ConfigPathHelper() {
    }

    public static String ensurePath(String configFile) {
        Path fullPath = FMLPaths.CONFIGDIR.get().resolve(configFile);
        Path parent = fullPath.getParent();
        if (parent != null) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.warn("Rustling Spots: failed to create config directory {} for {}", new Object[]{parent, configFile, e});
            }
        }
        return configFile;
    }
}

