/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.levelscraft7.rustlingspots.client.RustlingSpotClientHandler;
import net.levelscraft7.rustlingspots.config.RustlingSpotsClientConfig;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public final class RustlingSpotRenderer {
    private static final ResourceLocation SHADOW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"rustlingspots", (String)"textures/rs_ombres.png");
    private static final RenderType SHADOW_TRANSLUCENT_NO_DEPTH = RenderType.create((String)"rustlingspots_shadow_translucent_no_depth", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_TEX_LIGHTMAP_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(SHADOW_TEXTURE, false, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setWriteMaskState(RenderStateShard.COLOR_WRITE).setCullState(RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).createCompositeState(false));

    @SubscribeEvent
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        Camera camera = event.getCamera();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        RenderType type = SHADOW_TRANSLUCENT_NO_DEPTH;
        VertexConsumer consumer = bufferSource.getBuffer(type);
        for (RustlingSpotClientHandler.ClientSpot spot : RustlingSpotClientHandler.activeSpots()) {
            double visualTop;
            BlockPos pos = spot.getPos();
            BlockState state = level.getBlockState(pos);
            double collisionTop = state.getCollisionShape((BlockGetter)level, pos).max(Direction.Axis.Y);
            double topHeight = Math.max(collisionTop, visualTop = state.getShape((BlockGetter)level, pos).max(Direction.Axis.Y));
            if (topHeight < 0.01) {
                topHeight = 1.0;
            }
            double lowered = Math.max(topHeight - 0.98, 0.0);
            double y = (double)pos.getY() + lowered + 0.01;
            double camX = (double)pos.getX() + 0.5 - camera.getPosition().x();
            double camY = y - camera.getPosition().y();
            double camZ = (double)pos.getZ() + 0.5 - camera.getPosition().z();
            double time = level.getGameTime();
            double swayX = Math.sin((time + (double)pos.asLong()) * 0.05) * 0.01;
            double swayZ = Math.cos((time * 0.9 + (double)pos.asLong()) * 0.05) * 0.01;
            poseStack.pushPose();
            poseStack.translate(camX + swayX, camY, camZ + swayZ);
            RustlingSpotRenderer.addShadowQuad(poseStack, consumer, level, pos, RustlingSpotRenderer.resolveShadowColor(level, pos, camera));
            poseStack.popPose();
        }
        bufferSource.endBatch(type);
    }

    private static int resolveShadowColor(ClientLevel level, BlockPos pos, Camera camera) {
        boolean waterAtSpot = level.getFluidState(pos).is(FluidTags.WATER) || level.getFluidState(pos.above()).is(FluidTags.WATER);
        boolean cameraSubmerged = camera.getFluidInCamera() == FogType.WATER;
        int alpha = Mth.clamp((int)((int)(RustlingSpotsClientConfig.VISUAL.shadowOpacity() * 255.0f)), (int)0, (int)255);
        if (!waterAtSpot && !cameraSubmerged) {
            return FastColor.ARGB32.color((int)alpha, (int)255, (int)255, (int)255);
        }
        int waterColor = ((Biome)level.getBiome(pos).value()).getWaterColor();
        int r = FastColor.ARGB32.red((int)waterColor);
        int g = FastColor.ARGB32.green((int)waterColor);
        int b = FastColor.ARGB32.blue((int)waterColor);
        return FastColor.ARGB32.color((int)alpha, (int)r, (int)g, (int)b);
    }

    private static void addShadowQuad(PoseStack poseStack, VertexConsumer consumer, ClientLevel level, BlockPos pos, int color) {
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix = pose.pose();
        float halfSize = 0.44f;
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos.above());
        RustlingSpotRenderer.addVertex(matrix, consumer, -halfSize, 0.0f, -halfSize, 0.0f, 0.0f, light, color);
        RustlingSpotRenderer.addVertex(matrix, consumer, -halfSize, 0.0f, halfSize, 0.0f, 1.0f, light, color);
        RustlingSpotRenderer.addVertex(matrix, consumer, halfSize, 0.0f, halfSize, 1.0f, 1.0f, light, color);
        RustlingSpotRenderer.addVertex(matrix, consumer, halfSize, 0.0f, -halfSize, 1.0f, 0.0f, light, color);
    }

    private static void addVertex(Matrix4f matrix, VertexConsumer consumer, float x, float y, float z, float u, float v, int light, int color) {
        Vector4f transformed = new Vector4f(x, y, z, 1.0f).mul((Matrix4fc)matrix);
        consumer.addVertex(transformed.x(), transformed.y(), transformed.z(), color, u, v, OverlayTexture.NO_OVERLAY, light, 0.0f, 1.0f, 0.0f);
    }
}

