/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.levelscraft7.rustlingspots.client.RustlingAmbientSound;
import net.levelscraft7.rustlingspots.client.RustlingParticles;
import net.levelscraft7.rustlingspots.client.RustlingSpotRenderer;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotSpawnPacket;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;

public final class RustlingSpotClientHandler {
    private static final Map<UUID, ClientSpot> ACTIVE = new HashMap<UUID, ClientSpot>();
    private static ResourceKey<Level> currentDimension;

    private RustlingSpotClientHandler() {
    }

    public static void bootstrap() {
        NeoForge.EVENT_BUS.register((Object)new RustlingSpotClientHandler());
        NeoForge.EVENT_BUS.register((Object)new RustlingSpotRenderer());
    }

    public static Iterable<ClientSpot> activeSpots() {
        return ACTIVE.values();
    }

    public static void handleSpawn(RustlingSpotSpawnPacket packet) {
        ACTIVE.put(packet.id(), new ClientSpot(packet.id(), packet.pos(), packet.family(), packet.ambientVariant()));
    }

    public static void handleRemove(UUID id) {
        ClientSpot spot = ACTIVE.remove(id);
        if (spot != null) {
            spot.stop();
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        ResourceKey dimension;
        Minecraft mc = Minecraft.getInstance();
        ResourceKey resourceKey = dimension = mc.level != null ? mc.level.dimension() : null;
        if (mc.level == null || !Objects.equals(currentDimension, dimension)) {
            ACTIVE.values().forEach(ClientSpot::stop);
            ACTIVE.clear();
            currentDimension = dimension;
            return;
        }
        long time = mc.level.getGameTime();
        ACTIVE.values().forEach(spot -> spot.tick(time));
    }

    static final class ClientSpot {
        private final UUID id;
        private final BlockPos pos;
        private final RustlingSpotFamily family;
        private final int ambientVariant;
        private RustlingAmbientSound ambientSound;

        private ClientSpot(UUID id, BlockPos pos, RustlingSpotFamily family, int ambientVariant) {
            this.id = id;
            this.pos = pos;
            this.family = family;
            this.ambientVariant = ambientVariant;
        }

        BlockPos getPos() {
            return this.pos;
        }

        RustlingSpotFamily getFamily() {
            return this.family;
        }

        private void tick(long gameTime) {
            double dz;
            double dy;
            if (gameTime % 10L == 0L) {
                RustlingParticles.spawn(this.family, this.pos);
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                this.stop();
                return;
            }
            double dx = mc.player.getX() - ((double)this.pos.getX() + 0.5);
            double distance = Math.sqrt(dx * dx + (dy = mc.player.getY() - ((double)this.pos.getY() + 0.5)) * dy + (dz = mc.player.getZ() - ((double)this.pos.getZ() + 0.5)) * dz);
            if (distance <= 10.0) {
                this.ensureAmbientPlaying(distance);
            } else {
                this.stopAmbient();
            }
        }

        private void ensureAmbientPlaying(double distance) {
            if (this.ambientSound != null && !this.ambientSound.isStopped()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            if (mc.getSoundManager() == null) {
                return;
            }
            SoundEvent sound = (SoundEvent)RustlingSoundEvents.ambientVariant(this.ambientVariant).value();
            float initialVolume = RustlingAmbientSound.calculateVolume(distance);
            this.ambientSound = new RustlingAmbientSound(this.id, this.pos, sound, initialVolume);
            mc.getSoundManager().play((SoundInstance)this.ambientSound);
        }

        private void stopAmbient() {
            if (this.ambientSound != null && !this.ambientSound.isStopped()) {
                this.ambientSound.stopFromRemoval();
            }
        }

        private void stop() {
            this.stopAmbient();
        }
    }
}

