/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client;

import net.levelscraft7.rustlingspots.registry.RustlingParticleTypes;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public final class RustlingParticles {
    private RustlingParticles() {
    }

    public static void spawn(RustlingSpotFamily family, BlockPos pos) {
        double radius;
        double angle;
        int i;
        double visualTop;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        RandomSource random = level.getRandom();
        double collisionTop = level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).max(Direction.Axis.Y);
        double topHeight = Math.max(collisionTop, visualTop = level.getBlockState(pos).getShape((BlockGetter)level, pos).max(Direction.Axis.Y));
        if (topHeight < 0.01) {
            topHeight = 1.0;
        }
        Vec3 topCenter = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + topHeight + 0.02, (double)pos.getZ() + 0.5);
        Vec3 spotCenter = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.02, (double)pos.getZ() + 0.5);
        if (family == RustlingSpotFamily.GRASS || family == RustlingSpotFamily.LEAVES || family == RustlingSpotFamily.WATER || family == RustlingSpotFamily.SAND || family == RustlingSpotFamily.SNOW || family == RustlingSpotFamily.NETHERFLAMME || family == RustlingSpotFamily.SOULFLAME || family == RustlingSpotFamily.FLYING || family == RustlingSpotFamily.CAVE) {
            SimpleParticleType primary = switch (family) {
                case RustlingSpotFamily.GRASS -> (SimpleParticleType)RustlingParticleTypes.GRASS_BURST.get();
                case RustlingSpotFamily.LEAVES -> (SimpleParticleType)RustlingParticleTypes.LEAVES_BURST.get();
                case RustlingSpotFamily.WATER -> (SimpleParticleType)RustlingParticleTypes.WATER_BURST.get();
                case RustlingSpotFamily.CAVE -> (SimpleParticleType)RustlingParticleTypes.CAVE_BURST.get();
                case RustlingSpotFamily.SAND -> (SimpleParticleType)RustlingParticleTypes.SAND_BURST.get();
                case RustlingSpotFamily.SNOW -> (SimpleParticleType)RustlingParticleTypes.SNOW_BURST.get();
                case RustlingSpotFamily.NETHERFLAMME -> (SimpleParticleType)RustlingParticleTypes.NETHERFLAMME_BURST.get();
                case RustlingSpotFamily.SOULFLAME -> (SimpleParticleType)RustlingParticleTypes.SOULFLAME_BURST.get();
                case RustlingSpotFamily.FLYING -> (SimpleParticleType)RustlingParticleTypes.FLYING_BURST.get();
                default -> throw new IllegalStateException("Unexpected family: " + String.valueOf((Object)family));
            };
            LeafyBurstProfile leafyProfile = new LeafyBurstProfile((ParticleOptions)primary, 22, 28, 10, 15, 0.4f, 0.6f, 0.12f, 0.06f, 0.035f, 0.018f, 0.12f, 0.05f);
            RustlingParticles.emitLeafyBurst(level, random, spotCenter, leafyProfile);
            return;
        }
        switch (family) {
            default: {
                throw new MatchException(null, null);
            }
            case GRASS: {
                throw new IllegalStateException("handled above");
            }
            case LEAVES: {
                throw new IllegalStateException("handled above");
            }
            case WATER: {
                throw new IllegalStateException("handled above");
            }
            case CAVE: {
                throw new IllegalStateException("handled above");
            }
            case SAND: {
                throw new IllegalStateException("handled above");
            }
            case SNOW: {
                throw new IllegalStateException("handled above");
            }
            case NETHERFLAMME: {
                throw new IllegalStateException("handled above");
            }
            case SOULFLAME: {
                throw new IllegalStateException("handled above");
            }
            case FLYING: 
        }
        BurstProfile profile = new BurstProfile((ParticleOptions)RustlingParticleTypes.FLYING_BURST.get(), 26, 0.28f, 0.48f, 0.09f, 0.014f, (ParticleOptions)ParticleTypes.CLOUD);
        if (family == RustlingSpotFamily.FLYING) {
            RustlingParticles.emitFlyingBurst(level, random, topCenter, profile);
            return;
        }
        for (i = 0; i < profile.count; ++i) {
            angle = random.nextDouble() * Math.PI * 2.0;
            radius = Mth.lerp((double)random.nextDouble(), (double)profile.radiusMin, (double)profile.radiusMax);
            double offsetY = random.nextDouble() * 0.08;
            double x = topCenter.x + Math.cos(angle) * radius;
            double z = topCenter.z + Math.sin(angle) * radius;
            double y = topCenter.y + offsetY;
            double outward = 0.01 + random.nextDouble() * 0.01;
            double velX = Math.cos(angle) * outward * 0.8 + (random.nextDouble() - 0.5) * 0.012;
            double velZ = Math.sin(angle) * outward * 0.8 + (random.nextDouble() - 0.5) * 0.012;
            double velY = (double)profile.upwardBase + random.nextDouble() * (double)profile.upwardJitter + 0.01;
            level.addParticle(profile.primary, x, y, z, velX, velY, velZ);
        }
        for (i = 0; i < 20; ++i) {
            angle = random.nextDouble() * Math.PI * 2.0;
            radius = Mth.lerp((double)random.nextDouble(), (double)(profile.radiusMin * 0.6f), (double)(profile.radiusMax * 0.65f));
            double x = topCenter.x + Math.cos(angle) * radius;
            double z = topCenter.z + Math.sin(angle) * radius;
            double velY = (double)profile.upwardBase * 0.25;
            level.addParticle(profile.accent, x, topCenter.y + 0.02, z, 0.0, velY, 0.0);
        }
    }

    private static void emitLeafyBurst(ClientLevel level, RandomSource random, Vec3 center, LeafyBurstProfile profile) {
        int firstCount = profile.phaseOneMin + random.nextInt(profile.phaseOneMax - profile.phaseOneMin + 1);
        int secondCount = profile.phaseTwoMin + random.nextInt(profile.phaseTwoMax - profile.phaseTwoMin + 1);
        RustlingParticles.emitLeafyBurstPhase(level, random, center, profile, firstCount);
        RustlingParticles.emitLeafyBurstPhase(level, random, center, profile, secondCount);
    }

    private static void emitLeafyBurstPhase(ClientLevel level, RandomSource random, Vec3 center, LeafyBurstProfile profile, int count) {
        for (int i = 0; i < count; ++i) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double radius = Mth.lerp((double)random.nextDouble(), (double)profile.radiusMin, (double)profile.radiusMax);
            double x = center.x + Math.cos(angle) * radius;
            double z = center.z + Math.sin(angle) * radius;
            double y = center.y + (double)profile.yOffsetBase + random.nextDouble() * (double)profile.yOffsetJitter;
            double outward = (double)profile.horizontalBase + random.nextDouble() * (double)profile.horizontalJitter;
            double velX = Math.cos(angle) * outward + (random.nextDouble() - 0.5) * 0.01;
            double velZ = Math.sin(angle) * outward + (random.nextDouble() - 0.5) * 0.01;
            double velY = (double)profile.upwardBase + random.nextDouble() * (double)profile.upwardJitter;
            level.addParticle(profile.primary, x, y, z, velX, velY, velZ);
        }
    }

    private static void emitFlyingBurst(ClientLevel level, RandomSource random, Vec3 center, BurstProfile profile) {
        double radius;
        double angle;
        int i;
        for (i = 0; i < profile.count; ++i) {
            angle = random.nextDouble() * Math.PI * 2.0;
            radius = Mth.lerp((double)random.nextDouble(), (double)(profile.radiusMin * 0.5f), (double)(profile.radiusMax * 0.75f));
            double columnHeight = random.nextDouble() * 0.9;
            double x = center.x + Math.cos(angle) * radius;
            double z = center.z + Math.sin(angle) * radius;
            double y = center.y + columnHeight * 0.6;
            double baseSwirl = 0.03 + random.nextDouble() * 0.02;
            double swirlX = -Math.sin(angle) * baseSwirl;
            double swirlZ = Math.cos(angle) * baseSwirl;
            double velY = (double)profile.upwardBase * 0.7 + random.nextDouble() * ((double)profile.upwardJitter * 0.5);
            level.addParticle(profile.primary, x, y, z, swirlX, velY, swirlZ);
        }
        for (i = 0; i < 14; ++i) {
            angle = random.nextDouble() * Math.PI * 2.0;
            radius = Mth.lerp((double)random.nextDouble(), (double)(profile.radiusMin * 0.4f), (double)(profile.radiusMax * 0.6f));
            double x = center.x + Math.cos(angle) * radius;
            double z = center.z + Math.sin(angle) * radius;
            double velY = (double)profile.upwardBase * 0.2;
            level.addParticle(profile.accent, x, center.y + 0.02, z, 0.0, velY, 0.0);
        }
    }

    private record LeafyBurstProfile(ParticleOptions primary, int phaseOneMin, int phaseOneMax, int phaseTwoMin, int phaseTwoMax, float radiusMin, float radiusMax, float upwardBase, float upwardJitter, float horizontalBase, float horizontalJitter, float yOffsetBase, float yOffsetJitter) {
    }

    private record BurstProfile(ParticleOptions primary, int count, float radiusMin, float radiusMax, float upwardBase, float upwardJitter, ParticleOptions accent) {
    }
}

