/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client;

import java.util.UUID;
import net.levelscraft7.rustlingspots.config.RustlingSpotsSoundConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class RustlingAmbientSound
extends AbstractTickableSoundInstance {
    public static final double MAX_DISTANCE = 10.0;
    private final UUID id;
    private final BlockPos origin;
    private boolean removed;

    public RustlingAmbientSound(UUID id, BlockPos pos, SoundEvent event, float initialVolume) {
        super(event, SoundSource.BLOCKS, SoundInstance.createUnseededRandom());
        this.id = id;
        this.origin = pos;
        this.looping = true;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.relative = false;
        this.x = (double)pos.getX() + 0.5;
        this.y = (double)pos.getY() + 0.5;
        this.z = (double)pos.getZ() + 0.5;
        this.volume = initialVolume;
    }

    public void tick() {
        if (this.removed) {
            this.stop();
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            this.stop();
            return;
        }
        double distance = mc.player.position().distanceTo(Vec3.atCenterOf((Vec3i)this.origin));
        if (distance > 10.0) {
            this.stop();
            return;
        }
        this.volume = RustlingAmbientSound.calculateVolume(distance);
    }

    public static float calculateVolume(double distance) {
        float base = RustlingSpotsSoundConfig.SOUNDS.ambientVolume();
        float attenuation = (float)Math.max(0.0, (10.0 - distance) / 10.0);
        return base * attenuation;
    }

    public UUID getId() {
        return this.id;
    }

    public void stopFromRemoval() {
        this.removed = true;
        this.stop();
    }
}

