/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots;

import net.levelscraft7.rustlingspots.client.RustlingClientEvents;
import net.levelscraft7.rustlingspots.client.RustlingSpotClientHandler;
import net.levelscraft7.rustlingspots.config.RustlingSpotsClientConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsFamilySpawnConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsPokemonConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsSoundConfig;
import net.levelscraft7.rustlingspots.network.RustlingSpotsNetwork;
import net.levelscraft7.rustlingspots.registry.RustlingParticleTypes;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.LootPoolService;
import net.levelscraft7.rustlingspots.spot.PokemonPoolService;
import net.levelscraft7.rustlingspots.spot.RustlingSpotCommands;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamilyConfigService;
import net.levelscraft7.rustlingspots.spot.SpotSpawner;
import net.levelscraft7.rustlingspots.spot.SpotTicker;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="rustlingspots")
public class RustlingSpotsMod {
    public static final String MOD_ID = "rustlingspots";

    public RustlingSpotsMod() {
        IEventBus modBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        RustlingSoundEvents.register(modBus);
        RustlingParticleTypes.register(modBus);
        modBus.addListener(RustlingSpotsNetwork::register);
        modBus.addListener(this::onClientSetup);
        if (FMLEnvironment.dist.isClient()) {
            RustlingClientEvents.register(modBus);
            RustlingSpotsClientConfig.register(ModLoadingContext.get());
        }
        RustlingSpotsServerConfig.register(ModLoadingContext.get());
        RustlingSpotsFamilySpawnConfig.register(ModLoadingContext.get());
        RustlingSpotsPokemonConfig.register(ModLoadingContext.get());
        RustlingSpotsSoundConfig.register(ModLoadingContext.get());
        RustlingSpotFamilyConfigService.ensureDefaultsExist();
        LootPoolService.ensureDefaultsExist();
        PokemonPoolService.ensureDefaultsExist();
        NeoForge.EVENT_BUS.register((Object)new SpotSpawner());
        NeoForge.EVENT_BUS.register((Object)new SpotTicker());
        NeoForge.EVENT_BUS.register((Object)new RustlingSpotCommands());
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            RustlingSpotClientHandler.bootstrap();
        }
    }
}

