/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiContainer;
import net.creeperhost.polylib.client.modulargui.ModularGuiInjector;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class PolyJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"polylib", (String)"jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(ModularGuiContainer.class, (IGuiContainerHandler)new IGuiContainerHandler<ModularGuiContainer>(this){

            public List<Rect2i> getGuiExtraAreas(ModularGuiContainer containerScreen) {
                return containerScreen.getModularGui().getJeiExclusions().stream().map(e -> e.getRectangle().toRect2i()).toList();
            }
        });
        registration.addGuiContainerHandler(AbstractContainerScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<AbstractContainerScreen>(this){

            public List<Rect2i> getGuiExtraAreas(AbstractContainerScreen containerScreen) {
                ModularGui gui = ModularGuiInjector.getActiveGui();
                return gui == null ? Collections.emptyList() : gui.getJeiExclusions().stream().map(e -> e.getRectangle().toRect2i()).toList();
            }
        });
        registration.addGhostIngredientHandler(ModularGuiContainer.class, (IGhostIngredientHandler)new IngredientDropHandler());
    }

    private static class IngredientDropHandler
    implements IGhostIngredientHandler<ModularGuiContainer> {
        private ModularGui gui;
        private boolean highlight = true;

        private IngredientDropHandler() {
        }

        public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(ModularGuiContainer screen, ITypedIngredient<I> ingredient, boolean doStart) {
            this.gui = screen.getModularGui();
            this.gui.setJeiHighlightTime(doStart ? 1200 : 60);
            boolean bl = this.highlight = !doStart;
            if (!doStart) {
                return Collections.emptyList();
            }
            ArrayList targets = new ArrayList();
            ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).ifPresent(stack -> this.gui.getJeiDropTargets().forEach(e -> targets.add(new DropTarget((GuiElement<?>)e))));
            return targets;
        }

        public void onComplete() {
            this.highlight = true;
            this.gui.setJeiHighlightTime(0);
        }

        public boolean shouldHighlightTargets() {
            return this.highlight;
        }
    }

    private record DropTarget<I>(GuiElement<?> element) implements IGhostIngredientHandler.Target<I>
    {
        public Rect2i getArea() {
            return this.element.getRectangle().toRect2i();
        }

        public void accept(I ingredient) {
            this.element.getJeiDropConsumer().accept((ItemStack)ingredient);
        }
    }
}

