/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ProgressToast
implements Toast {
    private static final ResourceLocation BG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"polylib", (String)"textures/toast.png");
    private final Component title;
    private float progress;
    private float lastProgress;
    private long lastProgressTime;
    private final ResourceLocation iconResourceLocation;

    public ProgressToast(Component title, float progress, ResourceLocation resourceLocation) {
        this.title = title;
        this.progress = progress;
        this.iconResourceLocation = resourceLocation;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long l) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(BG_TEXTURE, 0, 0, 0.0f, 0.0f, this.width(), this.height(), this.width(), this.height());
        if (this.iconResourceLocation != null) {
            this.renderImage(guiGraphics, toastComponent, this.iconResourceLocation);
        }
        guiGraphics.drawString(Minecraft.getInstance().font, this.title, 30, 12, -1);
        guiGraphics.fill(3, 28, 157, 29, -1);
        float f = Mth.clampedLerp((float)this.lastProgress, (float)this.progress, (float)((float)(l - this.lastProgressTime) / 100.0f));
        int i = this.progress >= this.lastProgress ? -16755456 : -11206656;
        guiGraphics.fill(3, 28, (int)(3.0f + 154.0f * f), 29, i);
        this.lastProgress = f;
        this.lastProgressTime = l;
        if (this.progress >= 1.0f) {
            return Toast.Visibility.HIDE;
        }
        return Toast.Visibility.SHOW;
    }

    public void updateProgress(float progress) {
        this.progress = progress;
    }

    public void renderImage(GuiGraphics guiGraphics, ToastComponent toastComponent, ResourceLocation resourceLocation) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.enableBlend();
        guiGraphics.blit(resourceLocation, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.enableBlend();
    }
}

