/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.sprite;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSources;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public class ModSpriteResourceLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter ATLAS_INFO_CONVERTER = new FileToIdConverter("atlases", ".json");
    private final List<SpriteSource> sources;
    private final String modid;

    private ModSpriteResourceLoader(List<SpriteSource> list, String modid) {
        this.sources = list;
        this.modid = modid;
    }

    public List<Function<SpriteResourceLoader, SpriteContents>> list(ResourceManager arg) {
        final HashMap map = new HashMap();
        SpriteSource.Output output = new SpriteSource.Output(){

            public void add(ResourceLocation location, SpriteSource.SpriteSupplier arg2) {
                SpriteSource.SpriteSupplier spriteSupplier;
                if (location.getNamespace().equals(ModSpriteResourceLoader.this.modid) && (spriteSupplier = map.put(location, arg2)) != null) {
                    spriteSupplier.discard();
                }
            }

            public void removeAll(Predicate<ResourceLocation> predicate) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!predicate.test((ResourceLocation)entry.getKey())) continue;
                    ((SpriteSource.SpriteSupplier)entry.getValue()).discard();
                    iterator.remove();
                }
            }
        };
        this.sources.forEach(arg3 -> arg3.run(arg, output));
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(spriteResourceLoader -> MissingTextureAtlasSprite.create());
        builder.addAll(map.values());
        return builder.build();
    }

    public static ModSpriteResourceLoader load(ResourceManager arg, ResourceLocation arg2, String modid) {
        ResourceLocation resourceLocation = ATLAS_INFO_CONVERTER.idToFile(arg2);
        ArrayList<SpriteSource> list = new ArrayList<SpriteSource>();
        for (Resource resource : arg.getResourceStack(resourceLocation)) {
            try {
                BufferedReader bufferedReader = resource.openAsReader();
                try {
                    Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)bufferedReader));
                    DataResult var10001 = SpriteSources.FILE_CODEC.parse(dynamic);
                    Logger var10003 = LOGGER;
                    Objects.requireNonNull(var10003);
                    list.addAll((Collection)var10001.getOrThrow());
                }
                finally {
                    if (bufferedReader == null) continue;
                    bufferedReader.close();
                }
            }
            catch (Exception var11) {
                LOGGER.warn("Failed to parse atlas definition {} in pack {}", new Object[]{resourceLocation, resource.sourcePackId(), var11});
            }
        }
        return new ModSpriteResourceLoader(list, modid);
    }
}

