/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.utils;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class Utils {
    public static List<Ingredient> createCombinedResultIngredients(String mobIngredients, int minCount, int maxCount) {
        String[] ingredientIds = mobIngredients.split(",");
        ArrayList<Ingredient> resultIngredients = new ArrayList<Ingredient>();
        ArrayList<ItemStack> combinedItemStacks = new ArrayList<ItemStack>();
        for (int count = minCount; count <= maxCount; ++count) {
            for (String ingredientId : ingredientIds) {
                Item ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(ResourceLocation.parse((String)ingredientId.trim()));
                combinedItemStacks.add(new ItemStack((ItemLike)ingredientItem, count));
            }
        }
        resultIngredients.add(Ingredient.of((ItemStack[])combinedItemStacks.toArray(new ItemStack[0])));
        return resultIngredients;
    }

    public static BreedingRecipe createBreedingRecipe(EntityType<?> entityType, Ingredient combinedIngredient, Item spawnEggItem, Boolean needsToBeTamed, List<Ingredient> resultItemStacks, Boolean animalTrusting, @Nullable Ingredient combinedExtraIngredient) {
        ArrayList<ItemStack> mergedResultItemStacks = new ArrayList<ItemStack>();
        for (Ingredient resultItemStack : resultItemStacks) {
            ItemStack[] stacks = resultItemStack.getItems();
            mergedResultItemStacks.addAll(Arrays.asList(stacks));
        }
        return new BreedingRecipe(entityType, combinedIngredient, new ItemStack((ItemLike)spawnEggItem), needsToBeTamed, Ingredient.of((ItemStack[])mergedResultItemStacks.toArray(new ItemStack[0])), combinedExtraIngredient, animalTrusting);
    }

    public static Ingredient createCombinedIngredient(String mobIngredients) {
        String[] ingredientIds = mobIngredients.split(",");
        ArrayList<Ingredient> combinedIngredients = new ArrayList<Ingredient>();
        for (String ingredientId : ingredientIds) {
            if (ingredientId.trim().startsWith("#")) {
                combinedIngredients.add(CommonUtils.createTagIngredient(ingredientId));
                continue;
            }
            Item ingredientItem = JustEnoughBreeding.getItemFromLoaderRegistries(ResourceLocation.parse((String)ingredientId.trim()));
            combinedIngredients.add(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ingredientItem)}));
        }
        return Ingredient.of((ItemStack[])((ItemStack[])Arrays.stream((Ingredient[])combinedIngredients.toArray(Ingredient[]::new)).flatMap(ingredient -> Arrays.stream(ingredient.getItems())).distinct().toArray(ItemStack[]::new)));
    }

    public static void renderEntity(@NotNull PoseStack stack, double mouseX, LivingEntity currentLivingEntity) {
        float yawRadians;
        int entityPosX = 31;
        int entityPosY = 89;
        int ENTITY_RENDER_DISTANCE = 0xF000F0;
        float yaw = (float)(60.0 - mouseX);
        stack.pushPose();
        stack.translate((float)entityPosX, (float)entityPosY, 50.0f);
        AABB boundingBox = currentLivingEntity.getBoundingBox();
        double largestDimension = Math.max(boundingBox.getXsize(), Math.max(boundingBox.getYsize(), boundingBox.getZsize()));
        float desiredWidth = 30.0f;
        float desiredHeight = 40.0f;
        float scaleX = desiredWidth / (float)largestDimension;
        float scaleY = desiredHeight / (float)largestDimension;
        float scalingFactor = Math.min(scaleX, scaleY);
        if (currentLivingEntity instanceof Frog) {
            scalingFactor = 50.0f;
        }
        if (currentLivingEntity instanceof Axolotl || currentLivingEntity instanceof Cat || currentLivingEntity instanceof Pig || currentLivingEntity instanceof Wolf) {
            scalingFactor = 25.0f;
        }
        if (currentLivingEntity instanceof Ocelot || currentLivingEntity instanceof Fox || currentLivingEntity instanceof Turtle) {
            scalingFactor = 20.0f;
        }
        if (currentLivingEntity instanceof Hoglin || currentLivingEntity instanceof Horse || currentLivingEntity instanceof Panda) {
            scalingFactor = 15.0f;
        }
        if (currentLivingEntity instanceof Sniffer) {
            scalingFactor = 10.0f;
        }
        stack.scale(scalingFactor, scalingFactor, scalingFactor);
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        currentLivingEntity.yBodyRot = yawRadians = -(yaw / 40.0f) * 20.0f;
        currentLivingEntity.setYRot(yawRadians);
        currentLivingEntity.yHeadRot = yawRadians;
        currentLivingEntity.yHeadRotO = yawRadians;
        Minecraft instance = Minecraft.getInstance();
        EntityRenderDispatcher entityRenderDispatcher = instance.getEntityRenderDispatcher();
        entityRenderDispatcher.overrideCameraOrientation(new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f));
        entityRenderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource bufferSource = instance.renderBuffers().bufferSource();
        entityRenderDispatcher.render((Entity)currentLivingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, stack, (MultiBufferSource)bufferSource, ENTITY_RENDER_DISTANCE);
        bufferSource.endBatch();
        entityRenderDispatcher.setRenderShadow(true);
        stack.popPose();
    }
}

