/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue;

import fr.iglee42.createqualityoflife.registries.QOLEntityTypes;
import fr.iglee42.createqualityoflife.statue.Statue;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;

public class StatueItem
extends Item {
    public StatueItem(Item.Properties p_40503_) {
        super(p_40503_);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Direction direction = ctx.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.getLevel();
        BlockPlaceContext blockplacecontext = new BlockPlaceContext(ctx);
        BlockPos blockpos = blockplacecontext.getClickedPos();
        ItemStack itemstack = ctx.getItemInHand();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockpos);
        AABB aabb = ((EntityType)QOLEntityTypes.STATUE.get()).getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
        if (level.noCollision(null, aabb) && level.getEntities(null, aabb).isEmpty()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                Consumer consumer = EntityType.createDefaultStackConfig((ServerLevel)serverlevel, (ItemStack)itemstack, (Player)ctx.getPlayer());
                Statue statue = (Statue)((EntityType)QOLEntityTypes.STATUE.get()).create(serverlevel, consumer, blockpos, MobSpawnType.SPAWN_EGG, true, true);
                if (statue == null) {
                    return InteractionResult.FAIL;
                }
                if (ctx.getPlayer() != null && !(ctx.getPlayer() instanceof FakePlayer)) {
                    statue.setOwner(ctx.getPlayer().getUUID());
                }
                float f = (float)Mth.floor((float)((Mth.wrapDegrees((float)(ctx.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                statue.setEntityRotations(0.0f, f, 0.0f);
                serverlevel.addFreshEntityWithPassengers((Entity)statue);
                level.playSound(null, statue.getX(), statue.getY(), statue.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                statue.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)ctx.getPlayer());
            }
            itemstack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.FAIL;
    }
}

