/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.registries;

import com.simibubi.create.AllFluids;
import com.simibubi.create.api.event.PipeCollisionEvent;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.registries.QOLTags;
import java.util.function.Function;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@EventBusSubscriber
public class QOLFluids {
    public static final FluidEntry<BaseFlowingFluid.Flowing> SUPERHEATED_LAVA = ((FluidBuilder)((ItemBuilder)((FluidBuilder)CreateQOL.REGISTRATE.standardFluid("superheated_lava", SolidRenderedPlaceableFluidType.create(4947434, () -> Float.valueOf(0.0625f), entity -> entity.level().dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335)).lang("Super Lava").properties(b -> b.viscosity(6200).temperature(1500).density(3000).pathType(PathType.LAVA).adjacentPathType((PathType)null).supportsBoating(false).canDrown(false).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{Tags.Fluids.LAVA, QOLTags.QOLFluidsTags.SUPERHEATED_LAVA.tag}).source(BaseFlowingFluid.Source::new).block().properties(p -> p.mapColor(MapColor.COLOR_BLUE)).build()).bucket().onRegister(QOLFluids::registerFluidDispenseBehavior)).defaultModel().tag(new TagKey[]{Tags.Items.BUCKETS, QOLTags.QOLItemTags.SUPERHEATED_LAVA_BUCKETS.tag}).build()).register();
    private static final DispenseItemBehavior DEFAULT = new DefaultDispenseItemBehavior();
    private static final DispenseItemBehavior DISPENSE_FLUID = new DefaultDispenseItemBehavior(){

        protected ItemStack execute(BlockSource pSource, ItemStack pStack) {
            DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)pStack.getItem();
            BlockPos pos = pSource.pos().relative((Direction)pSource.state().getValue((Property)DispenserBlock.FACING));
            ServerLevel level = pSource.level();
            if (dispensibleContainerItem.emptyContents(null, (Level)level, pos, null, pStack)) {
                return new ItemStack((ItemLike)Items.BUCKET);
            }
            return DEFAULT.dispense(pSource, pStack);
        }
    };

    private static void registerFluidDispenseBehavior(BucketItem bucket) {
        DispenserBlock.registerBehavior((ItemLike)bucket, (DispenseItemBehavior)DISPENSE_FLUID);
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((BaseFlowingFluid.Flowing)SUPERHEATED_LAVA.get()).getFluidType(), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)NeoForgeMod.WATER_TYPE.value(), fluidState -> Blocks.OBSIDIAN.defaultBlockState()));
    }

    public static void register() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePipeFlowCollisionFallback(PipeCollisionEvent.Flow event) {
        BlockState lavaInteraction;
        Fluid f1 = event.getFirstFluid();
        Fluid f2 = event.getSecondFluid();
        if (f1 == Fluids.WATER && FluidHelper.hasBlockState((Fluid)f2)) {
            BlockState lavaInteraction2 = QOLFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)f2).defaultFluidState());
            if (lavaInteraction2 != null) {
                event.setState(lavaInteraction2);
            }
        } else if (f2 == Fluids.WATER && FluidHelper.hasBlockState((Fluid)f1) && (lavaInteraction = QOLFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)f1).defaultFluidState())) != null) {
            event.setState(lavaInteraction);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePipeSpillCollisionFallback(PipeCollisionEvent.Spill event) {
        BlockState lavaInteraction;
        Fluid pf = event.getPipeFluid();
        Fluid wf = event.getWorldFluid();
        if (pf == Fluids.WATER) {
            BlockState lavaInteraction2 = QOLFluids.getLavaInteraction(wf.defaultFluidState());
            if (lavaInteraction2 != null) {
                event.setState(lavaInteraction2);
            }
        } else if (wf == Fluids.FLOWING_WATER && FluidHelper.hasBlockState((Fluid)pf) && (lavaInteraction = QOLFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)pf).defaultFluidState())) != null) {
            event.setState(lavaInteraction);
        }
    }

    @Nullable
    public static BlockState getLavaInteraction(FluidState fluidState) {
        Fluid fluid = fluidState.getType();
        if (fluid.isSame((Fluid)SUPERHEATED_LAVA.get())) {
            return Blocks.OBSIDIAN.defaultBlockState();
        }
        return null;
    }

    private static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;
        private Function<Entity, Double> motionScale;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance, @Nullable Function<Entity, Double> motionScale) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f){};
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                fluidType.motionScale = motionScale;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            return super.move(state, entity, movementVector, gravity);
        }

        public double motionScale(Entity entity) {
            return this.motionScale != null ? this.motionScale.apply(entity).doubleValue() : super.motionScale(entity);
        }

        public void setItemMovement(ItemEntity entity) {
            Vec3 vec3 = entity.getDeltaMovement();
            entity.setDeltaMovement(vec3.x * (double)0.95f, vec3.y + (double)(vec3.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3.z * (double)0.95f);
        }
    }
}

