/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class StockManagerLockPacket
extends BlockEntityConfigurationPacket<StockManagerBlockEntity> {
    public static final StreamCodec<ByteBuf, StockManagerLockPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, p -> p.pos, (StreamCodec)ByteBufCodecs.BOOL, p -> p.lock, StockManagerLockPacket::new);
    private final boolean lock;

    public StockManagerLockPacket(BlockPos pos, boolean lock) {
        super(pos);
        this.lock = lock;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return QOLPackets.LOCK_STOCK_MANAGER;
    }

    protected void applySettings(ServerPlayer player, StockManagerBlockEntity be) {
        if (!be.behaviour.mayAdministrate((Player)player)) {
            return;
        }
        LogisticsNetwork network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(be.behaviour.freqId);
        if (network != null) {
            network.locked = this.lock;
            Create.LOGISTICS.markDirty();
        }
    }
}

