/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.UUID;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;

public class ModifyStockManagerLogisticNetworkPacket
extends BlockEntityConfigurationPacket<StockManagerBlockEntity> {
    public static final StreamCodec<ByteBuf, ModifyStockManagerLogisticNetworkPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, packet -> packet.pos, (StreamCodec)UUIDUtil.STREAM_CODEC, packet -> packet.networkId, ModifyStockManagerLogisticNetworkPacket::new);
    private final UUID networkId;

    public ModifyStockManagerLogisticNetworkPacket(BlockPos pos, UUID networkId) {
        super(pos);
        this.networkId = networkId;
    }

    protected void applySettings(ServerPlayer player, StockManagerBlockEntity stbe) {
        LogisticsNetwork network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(this.networkId);
        if (network != null) {
            stbe.behaviour.unload();
            stbe.behaviour.destroy();
            stbe.behaviour.freqId = this.networkId;
            stbe.behaviour.initialize();
            Create.LOGISTICS.linkAdded(this.networkId, GlobalPos.of((ResourceKey)stbe.getLevel().dimension(), (BlockPos)stbe.getBlockPos()), null);
            Create.LOGISTICS.linkLoaded(this.networkId, GlobalPos.of((ResourceKey)stbe.getLevel().dimension(), (BlockPos)stbe.getBlockPos()));
            stbe.setChanged();
            network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(this.networkId);
            boolean showLockOption = stbe.behaviour.mayAdministrate((Player)player) && Create.LOGISTICS.isLockable(stbe.behaviour.freqId);
            boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(stbe.behaviour.freqId);
            String name = ((LogisticsNetworkExtension)network).createQOL$getName();
            int links = network.totalLinks.size();
            HashMap<UUID, NetworkPermission> permissions = new HashMap<UUID, NetworkPermission>(((LogisticsNetworkExtension)network).createQOL$getPlayersPermission());
            if (network.owner != null) {
                permissions.put(network.owner, NetworkPermission.OWNER);
            }
            player.level().players().stream().filter(p -> !permissions.containsKey(p.getUUID())).forEach(p -> permissions.put(p.getUUID(), NetworkPermission.NONE));
            NetworkDestructionLevel desLevel = ((LogisticsNetworkExtension)network).createQOL$getDestructionLevel();
            boolean isOwner = player.getUUID().equals(network.owner);
            player.openMenu((MenuProvider)stbe.new StockManagerBlockEntity.StockManagerProvider(), buf -> {
                buf.writeBoolean(showLockOption);
                buf.writeBoolean(isOwner);
                buf.writeBoolean(isCurrentlyLocked);
                buf.writeUtf(name);
                buf.writeInt(links);
                NetworkDestructionLevel.STREAM_CODEC.encode(buf, (Object)desLevel);
                buf.writeBoolean(desLevel.canDestroy(stbe.behaviour.freqId, (Player)player));
                LogisticsNetworkExtension.PERMISSIONS_STREAM_CODEC.encode(buf, (Object)permissions);
                buf.writeBlockPos(this.pos);
            });
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return QOLPackets.MODIFY_STOCK_MANAGER_LOGISTICS_NETWORK;
    }
}

