/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.mixins;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.ScheduleItem;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.utils.Features;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ScheduleItem.class})
public class ScheduleItemMixin {
    @Inject(method={"use"}, remap=false, at={@At(value="HEAD")})
    private void inject(Level world, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!world.isClientSide && player.isCrouching() && hand == InteractionHand.MAIN_HAND) {
            boolean ended = false;
            for (int x = -5; x <= 5; ++x) {
                for (int y = -5; y <= 5; ++y) {
                    for (int z = -5; z <= 5; ++z) {
                        if (!(world.getBlockState(player.getOnPos().above().offset(x, y, z)).getBlock() instanceof StationBlock) || !CreateQOL.isActivate(Features.PROXIMITY_SCHEDULE)) continue;
                        ScheduleEntry entry = new ScheduleEntry();
                        ScheduledDelay delay = new ScheduledDelay();
                        ArrayList<ScheduledDelay> initialConditions = new ArrayList<ScheduledDelay>();
                        initialConditions.add(delay);
                        CompoundTag instr = new CompoundTag();
                        instr.putString("Id", "create:destination");
                        CompoundTag data = new CompoundTag();
                        data.putString("Text", ((StationBlockEntity)world.getBlockEntity((BlockPos)player.getOnPos().above().offset((int)x, (int)y, (int)z))).getStation().name);
                        instr.put("Data", (Tag)data);
                        entry.instruction = DestinationInstruction.fromTag((HolderLookup.Provider)player.registryAccess(), (CompoundTag)instr);
                        entry.conditions.add(initialConditions);
                        ItemStack currentItem = player.getItemInHand(hand);
                        if (ScheduleItem.getSchedule((HolderLookup.Provider)player.registryAccess(), (ItemStack)currentItem) == null) {
                            schedule = new Schedule();
                            schedule.entries.add(entry);
                            currentItem.set(AllDataComponents.TRAIN_SCHEDULE, (Object)schedule.write((HolderLookup.Provider)player.registryAccess()));
                        } else {
                            schedule = ScheduleItem.getSchedule((HolderLookup.Provider)player.registryAccess(), (ItemStack)currentItem);
                            schedule.entries.add(entry);
                            currentItem.remove(AllDataComponents.TRAIN_SCHEDULE);
                            currentItem.set(AllDataComponents.TRAIN_SCHEDULE, (Object)schedule.write((HolderLookup.Provider)player.registryAccess()));
                        }
                        ended = true;
                        player.getCooldowns().addCooldown(currentItem.getItem(), 5);
                        break;
                    }
                    if (ended) break;
                }
                if (ended) break;
            }
        }
    }
}

