/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.mixins;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.legacy.ChromaticCompoundItem;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChromaticCompoundItem.class})
public class ChromaticCompoundItemMixin {
    @Inject(method={"onEntityItemUpdate"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onEntityItemUpdate(ItemStack stack, ItemEntity entity, CallbackInfoReturnable<Boolean> cir) {
        Level world = entity.level();
        if (((Boolean)AllConfigs.server().recipes.enableRefinedRadianceRecipe.get()).booleanValue()) {
            boolean isOverBeacon = false;
            int entityX = Mth.floor((double)entity.getX());
            int entityZ = Mth.floor((double)entity.getZ());
            int localWorldHeight = world.getHeight(Heightmap.Types.WORLD_SURFACE, entityX, entityZ);
            BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(entityX, Math.min(Mth.floor((double)entity.getY()), localWorldHeight), entityZ);
            while (testPos.getY() > -64) {
                BeaconBlockEntity bte;
                testPos.move(Direction.DOWN);
                BlockState state = world.getBlockState((BlockPos)testPos);
                if (state.getBlock() != Blocks.BEACON) continue;
                BlockEntity be = world.getBlockEntity((BlockPos)testPos);
                if (!(be instanceof BeaconBlockEntity) || (bte = (BeaconBlockEntity)be).getBeamSections().isEmpty()) break;
                isOverBeacon = true;
                break;
            }
            CompoundTag data = entity.getPersistentData();
            if (isOverBeacon) {
                ItemStack newStack = AllItems.REFINED_RADIANCE.asStack();
                newStack.setCount(stack.getCount());
                data.putBoolean("JustCreated", true);
                entity.setItem(newStack);
                cir.setReturnValue((Object)false);
            }
        }
    }
}

