/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.shadowradiance;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.BooleanEntry;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.items.tools.refinedradiance.RefinedRadianceShovel;
import fr.iglee42.createqualityoflife.items.tools.shadowsteel.ShadowSteelShovel;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ShadowRadianceShovel
extends ShovelItem
implements QOLConfigurableItem {
    public ShadowRadianceShovel(Item.Properties p_42964_) {
        super((Tier)QOLTiers.SHADOW_RADIANCE, p_42964_);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.reach").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.smelting").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.smelting.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.SMELTING, (Object)false), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.digging").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.digging.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.DIGGING, (Object)false), false, true)));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Smelting", (Boolean)stack.getOrDefault(QOLDataComponents.SMELTING, (Object)false), QOLDataComponents.SMELTING, List.of("Should smelt the mined blocks"), (entry, oe) -> {
            boolean flag = oe.stream().noneMatch(e -> {
                BooleanEntry oEntry;
                return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getComponent().equals(QOLDataComponents.DIGGING) && (Boolean)oEntry.getValue() != false;
            });
            return (Boolean)CreateQOLConfigs.server().equipments.tools.smelting.get() != false && flag;
        }));
        list.add(QOLConfigurableItem.Configuration.ofBool("Digging", (Boolean)stack.getOrDefault(QOLDataComponents.DIGGING, (Object)false), QOLDataComponents.DIGGING, List.of("Activate the 3x3x3 digging when mining a block"), (entry, oe) -> {
            boolean flag = oe.stream().noneMatch(e -> {
                BooleanEntry oEntry;
                return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getComponent().equals(QOLDataComponents.VEIN_MINE) && (Boolean)oEntry.getValue() != false;
            });
            return (Boolean)CreateQOLConfigs.server().equipments.tools.digging.get() != false && flag;
        }));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)true);
        }
        if (player.isCrouching()) {
            if (((Boolean)player.getItemInHand(hand).getOrDefault(QOLDataComponents.SMELTING, (Object)false)).booleanValue()) {
                player.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.unavailable", CreateQOLLang.translateDirect("ability.tool.digging", new Object[0]).getString(), CreateQOLLang.translateDirect("ability.tool.smelting", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            } else {
                ShadowSteelShovel.toggleAbility(player.getItemInHand(hand), player);
            }
        } else if (((Boolean)player.getItemInHand(hand).getOrDefault(QOLDataComponents.DIGGING, (Object)false)).booleanValue()) {
            player.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.unavailable", CreateQOLLang.translateDirect("ability.tool.smelting", new Object[0]).getString(), CreateQOLLang.translateDirect("ability.tool.digging", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
        } else {
            RefinedRadianceShovel.toggleAbility(player.getItemInHand(hand), player);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BLOCK;
    }

    @Override
    public double reachModifier(ItemStack stack) {
        return 1.0;
    }
}

