/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.refinedradiance;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RefinedRadianceAxe
extends AxeItem
implements QOLConfigurableItem {
    public RefinedRadianceAxe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.REFINED_RADIANCE, p_42964_);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.reach").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.casingifier").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.casingifier.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.CASINGIFIER, (Object)false), false, true)));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Casingifier", (Boolean)stack.getOrDefault(QOLDataComponents.CASINGIFIER, (Object)false), QOLDataComponents.CASINGIFIER, List.of("When stripping a log transform it into casing if a valid casing ingredient is available in the off hand", "It also transform adjacent blocks"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.casingifier.get()));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)true);
        }
        if (player.isCrouching()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        RefinedRadianceAxe.toggleAbility(player.getItemInHand(hand), player);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.casingifier.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.casingifier", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        boolean enable = (Boolean)stack.getOrDefault(QOLDataComponents.CASINGIFIER, (Object)false) == false;
        stack.set(QOLDataComponents.CASINGIFIER, (Object)enable);
        p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.casingifier", new Object[0]).getString()).append(QOLConfigurableItem.chooseState(true, true, enable, false, true)).withStyle(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.casingifier.get()).booleanValue() || !((Boolean)ctx.getItemInHand().getOrDefault(QOLDataComponents.CASINGIFIER, (Object)false)).booleanValue()) {
            return super.useOn(ctx);
        }
        Level level = ctx.getLevel();
        BlockPos origin = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (RefinedRadianceAxe.playerHasShieldUseIntent((UseOnContext)ctx)) {
            return InteractionResult.PASS;
        }
        ItemStack tool = ctx.getItemInHand();
        ItemStack offHandStack = player.getOffhandItem();
        int limit = (Integer)CreateQOLConfigs.server().equipments.tools.casingifierMaxBlocks.get();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toVisit = new ArrayDeque<BlockPos>();
        toVisit.add(origin);
        int count = 0;
        while (!toVisit.isEmpty() && count < limit) {
            boolean success;
            BlockPos pos = (BlockPos)toVisit.poll();
            if (!visited.add(pos) || !(success = this.transformBlock(level, pos, player, ctx, offHandStack, (bs, recipe) -> {
                boolean keepHeld;
                level.setBlock(pos, bs, 3);
                recipe.rollResults(ctx.getLevel().random).forEach(stack -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
                boolean creative = player.isCreative();
                boolean unbreakable = offHandStack.has(DataComponents.UNBREAKABLE);
                boolean bl = keepHeld = recipe.shouldKeepHeldItem() || creative;
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(sp, pos, tool);
                }
                tool.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
                if (!unbreakable && !keepHeld) {
                    this.consumeItem(player, offHandStack);
                }
                RefinedRadianceAxe.awardAdvancements(player, bs);
            }))) continue;
            ++count;
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = pos.relative(dir);
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return count > 0 ? InteractionResult.sidedSuccess((boolean)level.isClientSide) : InteractionResult.PASS;
    }

    private void consumeItem(Player player, ItemStack reference) {
        if (reference.isEmpty()) {
            return;
        }
        if (reference.isDamageableItem()) {
            reference.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.OFFHAND);
        } else {
            player.getOffhandItem().shrink(1);
        }
    }

    private boolean transformBlock(Level level, BlockPos blockpos, Player player, UseOnContext ctx, ItemStack offHandStack, BiConsumer<BlockState, ManualApplicationRecipe> onSuccess) {
        Optional optional = this.evaluateNewBlockState(level, blockpos, player, level.getBlockState(blockpos), ctx);
        if (optional.isEmpty()) {
            return false;
        }
        RecipeType type = AllRecipeTypes.ITEM_APPLICATION.getType();
        Optional<RecipeHolder> foundRecipe = level.getRecipeManager().getAllRecipesFor(type).stream().filter(r -> {
            ManualApplicationRecipe mar = (ManualApplicationRecipe)r.value();
            return mar.testBlock((BlockState)optional.get()) && ((Ingredient)mar.getIngredients().get(1)).test(offHandStack);
        }).findFirst();
        if (foundRecipe.isEmpty()) {
            return false;
        }
        ManualApplicationRecipe recipe = (ManualApplicationRecipe)foundRecipe.get().value();
        level.destroyBlock(blockpos, false);
        BlockState transformedBlock = recipe.transformBlock((BlockState)optional.get(), ctx.getLevel().random);
        onSuccess.accept(transformedBlock, recipe);
        return true;
    }

    private static void awardAdvancements(Player player, BlockState placed) {
        CreateAdvancement advancement = null;
        if (AllBlocks.ANDESITE_CASING.has(placed)) {
            advancement = AllAdvancements.ANDESITE_CASING;
        } else if (AllBlocks.BRASS_CASING.has(placed)) {
            advancement = AllAdvancements.BRASS_CASING;
        } else if (AllBlocks.COPPER_CASING.has(placed)) {
            advancement = AllAdvancements.COPPER_CASING;
        } else if (AllBlocks.RAILWAY_CASING.has(placed)) {
            advancement = AllAdvancements.TRAIN_CASING;
        } else {
            return;
        }
        advancement.awardTo(player);
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BOTH;
    }
}

