/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.armors;

import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLArmorMaterials;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.KeyBindManager;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShadowSteelChestplate
extends BacktankItem.Layered
implements QOLConfigurableItem {
    public ShadowSteelChestplate(Item.Properties properties, Supplier<BacktankItem.BacktankBlockItem> placeable) {
        super(QOLArmorMaterials.SHADOW_STEEL, properties, CreateQOL.asResource("shadow_steel"), placeable);
    }

    public static void dash(ItemStack chestplate, ServerPlayer player) {
        if (!((Boolean)chestplate.getOrDefault(QOLDataComponents.DASH, (Object)true)).booleanValue()) {
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get()).booleanValue()) {
            player.displayClientMessage((Component)CreateQOLLang.translateDirect("armor.ability.dash_disabled", new Object[0]).withStyle(ChatFormatting.RED), true);
            return;
        }
        if (player.getCooldowns().isOnCooldown(chestplate.getItem())) {
            player.displayClientMessage((Component)CreateQOLLang.translateDirect("armor.ability.dash_reloading", new Object[0]).withStyle(ChatFormatting.RED), true);
            return;
        }
        Vec3 look = player.getLookAngle().normalize().scale(2.5);
        look = new Vec3(look.x, Math.clamp(look.y, -0.5, 0.5), look.z);
        player.setDeltaMovement(player.getDeltaMovement().add(look));
        player.hurtMarked = true;
        player.getCooldowns().addCooldown(chestplate.getItem(), ((Integer)CreateQOLConfigs.server().equipments.armors.dashCooldown.get()).intValue());
    }

    public void inventoryTick(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        this.invTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.air").getString()}).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.valueOf(BacktankUtil.getAir((ItemStack)stack))).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)("/" + BacktankUtil.maxAir((ItemStack)stack))).withStyle(ChatFormatting.GOLD)));
        components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.dash").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.cooldownState((Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get(), (Boolean)stack.getOrDefault(QOLDataComponents.DASH, (Object)true), (int)Math.ceil(Minecraft.getInstance().player.getCooldowns().getCooldownPercent((Item)this, 0.0f) * (float)((Integer)CreateQOLConfigs.server().equipments.armors.dashCooldown.get()).intValue()))));
        components.add((Component)Component.translatable((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.armor.arms").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState(true, true, (Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_ARMS, (Object)true), false, true)));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.UNBREAKING)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ARMOR;
    }

    @Override
    public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return Arrays.asList(ArmorRenderType.ALL, ArmorRenderType.NONE);
    }

    @Override
    public Holder<MobEffect> providedEffect(ItemStack stack) {
        return MobEffects.DAMAGE_BOOST;
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Enable Custom Arms", (Boolean)stack.getOrDefault(QOLDataComponents.BACKTANK_ARMS, (Object)true), QOLDataComponents.BACKTANK_ARMS, List.of("Should the player's arms be replaced with the armor in first person"), (e, oe) -> true));
        list.add(QOLConfigurableItem.Configuration.ofBool("Enable Dash", (Boolean)stack.getOrDefault(QOLDataComponents.DASH, (Object)true), QOLDataComponents.DASH, List.of("Should the player dash when pressing " + KeyBindManager.DASH_KEY.getTranslatedKeyMessage().getString()), (o, oe) -> (Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get()));
    }

    public boolean isBarVisible(ItemStack stack) {
        return super.isBarVisible(stack) && BacktankUtil.getAir((ItemStack)stack) < BacktankUtil.maxAir((ItemStack)stack);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }
}

