/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blocks;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.armor.BacktankBlock;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.blockentitites.ShadowRadianceBacktankBE;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.items.armors.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.registries.QOLBlockEntities;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ShadowRadianceBacktankBlock
extends BacktankBlock {
    public static final BooleanProperty PROPELLER = BooleanProperty.create((String)"propeller");

    public ShadowRadianceBacktankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PROPELLER, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PROPELLER});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)PROPELLER, (Comparable)Boolean.valueOf(false));
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            ((ShadowRadianceBacktankBE)((Object)be)).setPropeller(ShadowRadianceChestplate.hasPropeller(stack));
            ((ShadowRadianceBacktankBE)((Object)be)).setFans(ShadowRadianceChestplate.isFansEnable(stack));
            ((ShadowRadianceBacktankBE)((Object)be)).setHover(ShadowRadianceChestplate.isHoverEnable(stack));
            ((ShadowRadianceBacktankBE)((Object)be)).setElytra(ShadowRadianceChestplate.hasElytra(stack));
        });
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof ShadowRadianceBacktankBE) {
            ShadowRadianceBacktankBE be = (ShadowRadianceBacktankBE)blockEntity;
            if (!be.hasPropeller() && AllItems.PROPELLER.is(player.getMainHandItem().getItem())) {
                if (!((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get()).booleanValue()) {
                    player.displayClientMessage((Component)CreateQOLLang.translateDirect("backtank.propeller_disabled", new Object[0]).withStyle(ChatFormatting.RED), true);
                    level.playSound(null, pos, AllSoundEvents.DENY.getMainEvent(), SoundSource.PLAYERS, 1.0f, 1.45f);
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                be.setPropeller(true);
                if (be.hasPropeller()) {
                    player.getMainHandItem().shrink(1);
                    level.playSound(null, pos, SoundEvents.COPPER_BREAK, SoundSource.PLAYERS, 1.0f, 1.45f);
                }
                return ItemInteractionResult.CONSUME;
            }
            if (!be.hasElytra() && player.getMainHandItem().is(Items.ELYTRA)) {
                if (!((Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get()).booleanValue()) {
                    player.displayClientMessage((Component)CreateQOLLang.translateDirect("backtank.elytra_disabled", new Object[0]).withStyle(ChatFormatting.RED), true);
                    level.playSound(null, pos, AllSoundEvents.DENY.getMainEvent(), SoundSource.PLAYERS, 1.0f, 1.45f);
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                be.setElytra(true);
                if (be.hasElytra()) {
                    ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
                    if (enchantments != null && !enchantments.isEmpty()) {
                        ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                        book.set(DataComponents.STORED_ENCHANTMENTS, (Object)enchantments);
                        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)book);
                    }
                    player.getMainHandItem().shrink(1);
                    level.playSound(null, pos, SoundEvents.COPPER_BREAK, SoundSource.PLAYERS, 1.0f, 1.45f);
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(pLevel, pos, state);
        Item item = this.asItem();
        if (item instanceof BacktankItem.BacktankBlockItem) {
            BacktankItem.BacktankBlockItem placeable = (BacktankItem.BacktankBlockItem)item;
            item = placeable.getActualItem();
        }
        Optional blockEntityOptional = this.getBlockEntityOptional((BlockGetter)pLevel, pos);
        blockEntityOptional.ifPresent(obe -> {
            ShadowRadianceBacktankBE be = (ShadowRadianceBacktankBE)((Object)obe);
            boolean propeller = be.hasPropeller();
            boolean fans = be.isFans();
            boolean hover = be.isHover();
            boolean elytra = be.hasElytra();
            stack.set(QOLDataComponents.BACKTANK_PROPELLERS, (Object)propeller);
            stack.set(QOLDataComponents.BACKTANK_FANS, (Object)fans);
            stack.set(QOLDataComponents.BACKTANK_HOVER, (Object)hover);
            stack.set(QOLDataComponents.BACKTANK_ELYTRA, (Object)elytra);
        });
        return stack;
    }

    public Class<BacktankBlockEntity> getBlockEntityClass() {
        return super.getBlockEntityClass();
    }

    public BlockEntityType<? extends BacktankBlockEntity> getBlockEntityType() {
        return (BlockEntityType)QOLBlockEntities.SHADOW_CHEST_BE.get();
    }
}

