/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.content.logistics.tunnel.BrassTunnelModeSlot;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createqualityoflife.blockentitites.TrashCanBlockEntity;
import fr.iglee42.createqualityoflife.blocks.BrassTrashCanBlock;
import fr.iglee42.createqualityoflife.registries.QOLBlockEntities;
import fr.iglee42.createqualityoflife.utils.BrassTrashCanFilterSlotPositioning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BrassTrashCanBlockEntity
extends TrashCanBlockEntity {
    FilteringBehaviour filtering;
    protected ScrollOptionBehaviour<Mode> selectionMode;

    public BrassTrashCanBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)QOLBlockEntities.BRASS_TRASH_CAN.get(), (be, context) -> be.itemHandler);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)QOLBlockEntities.BRASS_TRASH_CAN.get(), (be, context) -> be.tankInventory);
    }

    @Override
    public boolean canAcceptItem(ItemStack stack) {
        return super.canAcceptItem(stack) && this.canActivate() && this.filtering.test(stack) && (Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.POWERED) == false;
    }

    @Override
    public boolean canAcceptFluid(FluidStack stack) {
        return super.canAcceptFluid(stack) && this.canActivate() && this.filtering.test(stack) && (Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.POWERED) == false;
    }

    @Override
    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    @Override
    @NotNull
    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() && !this.filtering.upTo ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new BrassTrashCanFilterSlotPositioning()).showCountWhen(() -> (Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.OPEN));
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.selectionMode = (ScrollOptionBehaviour)new ScrollOptionBehaviour(Mode.class, (Component)CreateLang.translateDirect((String)"options.brass_trash_can.label", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new BrassTunnelModeSlot()).onlyActiveWhen(() -> (Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.OPEN) == false);
        behaviours.add((BlockEntityBehaviour)this.selectionMode);
        super.addBehaviours(behaviours);
    }

    public void tick() {
        boolean clientSide;
        super.tick();
        boolean bl = clientSide = this.level != null && this.level.isClientSide && !this.isVirtual();
        if (!clientSide && ((Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.OPEN)).booleanValue() && !((Boolean)this.getBlockState().getValue((Property)BrassTrashCanBlock.POWERED)).booleanValue()) {
            boolean flag;
            IItemHandler handler;
            if (((Mode)this.selectionMode.get()).equals((Object)Mode.KEEP_64)) {
                handler = this.grabCapability(Direction.UP);
                if (handler != null) {
                    ArrayList<Item> savedItems = new ArrayList<Item>();
                    for (i = 0; i < handler.getSlots(); ++i) {
                        stack = handler.getStackInSlot(i);
                        if (!this.canAcceptItem(stack)) continue;
                        if (!savedItems.contains(stack.getItem())) {
                            savedItems.add(stack.getItem());
                            continue;
                        }
                        handler.extractItem(i, this.filtering.count, false);
                    }
                }
            } else if (((Mode)this.selectionMode.get()).equals((Object)Mode.VOID_OVERFLOW)) {
                handler = this.grabCapability(Direction.UP);
                if (handler != null) {
                    boolean hasAnEmptySlot = false;
                    for (i = 0; i < handler.getSlots(); ++i) {
                        stack = handler.getStackInSlot(i);
                        if (!hasAnEmptySlot) {
                            if (stack.isEmpty()) {
                                hasAnEmptySlot = true;
                                continue;
                            }
                            if (!this.canAcceptItem(stack)) continue;
                            handler.extractItem(i, this.filtering.count, false);
                            hasAnEmptySlot = true;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.handleInputFromAbove();
            }
            if (((Mode)this.selectionMode.get()).equals((Object)Mode.VOID_OVERFLOW)) {
                handler = this.grabFluidCapability(Direction.UP);
                if (handler != null) {
                    for (int t = 0; t < handler.getTanks(); ++t) {
                        FluidStack stack = handler.getFluidInTank(t);
                        if (stack.getAmount() <= handler.getTankCapacity(t) - 1000) continue;
                        int toDrain = stack.getAmount() - (handler.getTankCapacity(t) - 1000);
                        handler.drain(stack.copyWithAmount(toDrain), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
            } else {
                this.handleFluidInputFromAbove();
            }
            boolean bl2 = flag = this.level.getBlockState(this.getBlockPos().above()).isCollisionShapeFullBlock((BlockGetter)this.level, this.getBlockPos().above()) && !this.level.getBlockState(this.getBlockPos().above()).is(BlockTags.DOES_NOT_BLOCK_HOPPERS);
            if (!flag) {
                BrassTrashCanBlockEntity.getItemsAtAndAbove(this.level, this.getBlockPos()).forEach(ie -> {
                    if (this.canAcceptItem(ie.getItem())) {
                        ie.discard();
                    }
                });
            }
        }
    }

    private static List<ItemEntity> getItemsAtAndAbove(Level p_155590_, BlockPos p_155591_) {
        AABB aabb = ((AABB)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)18.0, (double)16.0).toAabbs().get(0)).move((double)p_155591_.getX(), (double)p_155591_.getY(), (double)p_155591_.getZ());
        return p_155590_.getEntitiesOfClass(ItemEntity.class, aabb, EntitySelector.ENTITY_STILL_ALIVE);
    }

    public static enum Mode implements INamedIconOptions
    {
        VOID(0, AllIcons.I_TRASH),
        KEEP_64(1, AllIcons.I_3x3),
        VOID_OVERFLOW(2, AllIcons.I_SKIP_BLOCK_ENTITIES);

        private int id;
        private AllIcons icon;

        private Mode(int id, AllIcons icon) {
            this.id = id;
            this.icon = icon;
        }

        public int getId() {
            return this.id;
        }

        public static Mode getById(int id) {
            return Arrays.stream(Mode.values()).filter(m -> m.getId() == id).findFirst().orElse(VOID);
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return "options.brass_trash_can." + this.name().toLowerCase();
        }
    }
}

