/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.particle.AirParticleData;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.client.renderer.ArmorsArmsRenderer;
import fr.iglee42.createqualityoflife.client.renderer.EnderRenderer;
import fr.iglee42.createqualityoflife.client.renderer.GoggleArmorLayer;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.items.armors.ShadowRadianceArmorItem;
import fr.iglee42.createqualityoflife.items.armors.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.items.armors.ShadowSteelArmorItem;
import fr.iglee42.createqualityoflife.ponder.QOLPonderPlugin;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLEntityTypes;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLPartialModels;
import fr.iglee42.createqualityoflife.registries.QOLSprites;
import fr.iglee42.createqualityoflife.statue.StatueModel;
import fr.iglee42.createqualityoflife.statue.StatueRenderer;
import fr.iglee42.createqualityoflife.utils.CommonKeysHandler;
import fr.iglee42.createqualityoflife.utils.KeyBindManager;
import fr.iglee42.createqualityoflife.utils.Pos3D;
import java.util.Random;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.ponder.PonderClient;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateQOLClient {
    public static final ModelLayerLocation STATUE = new ModelLayerLocation(CreateQOL.asResource("statue"), "main");
    public static final ModelLayerLocation STATUE_INNER_ARMOR = new ModelLayerLocation(CreateQOL.asResource("statue"), "inner_armor");
    public static final ModelLayerLocation STATUE_OUTER_ARMOR = new ModelLayerLocation(CreateQOL.asResource("statue"), "outer_armor");
    private static final Logger log = LoggerFactory.getLogger(CreateQOLClient.class);

    public static void onCtorClient(IEventBus modEventBus, IEventBus forgeEventBus) {
        QOLPartialModels.init();
        modEventBus.addListener(CreateQOLClient::clientInit);
        modEventBus.addListener(CreateQOLClient::addEntityRendererLayers);
        modEventBus.addListener(CreateQOLClient::registerKeys);
        modEventBus.addListener(CreateQOLClient::registerEntityRendererLayers);
        forgeEventBus.addListener(CreateQOLClient::onClientTick);
        forgeEventBus.addListener(CreateQOLClient::onPlayerTick);
        forgeEventBus.addListener(CreateQOLClient::onLivingJump);
    }

    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(KeyBindManager.FANS_KEY);
        event.register(KeyBindManager.HOVER_KEY);
        event.register(KeyBindManager.ELYTRA_KEY);
        event.register(KeyBindManager.TOGGLE_FANS_ELYTRA_KEY);
        event.register(KeyBindManager.OPEN_ARMOR_CONFIG);
        event.register(KeyBindManager.DASH_KEY);
        event.register(KeyBindManager.HELMET_EFFECT_KEY);
        event.register(KeyBindManager.CHESTPLATE_EFFECT_KEY);
        event.register(KeyBindManager.LEGGINGS_EFFECT_KEY);
        event.register(KeyBindManager.BOOTS_EFFECT_KEY);
    }

    public static void clientInit(FMLClientSetupEvent event) {
        new QOLSprites();
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)QOLItems.PLAYER_PAPER.get()), (ResourceLocation)CreateQOL.asResource("has_player"), (stack, level, living, id) -> stack.has(QOLDataComponents.LINKED_PLAYER) ? 1.0f : 0.0f));
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)QOLItems.SHADOW_RADIANCE_CHESTPLATE.get()), (ResourceLocation)CreateQOL.asResource("elytra"), (stack, level, living, id) -> ShadowRadianceChestplate.hasElytra(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)QOLItems.REFINED_RADIANCE_CHESTPLATE.get()), (ResourceLocation)CreateQOL.asResource("elytra"), (stack, level, living, id) -> ShadowRadianceChestplate.hasElytra(stack) ? 1.0f : 0.0f);
        });
        EntityRenderers.register((EntityType)((EntityType)QOLEntityTypes.STATUE.get()), StatueRenderer::new);
        PonderIndex.addPlugin((PonderPlugin)new QOLPonderPlugin());
    }

    public static void showPropellers(BlockState renderedState, int light, PoseStack ms, MultiBufferSource buffer, RenderType renderType, LevelAccessor level) {
        PartialModel partial = AnimationTickHolder.getRenderTime((LevelAccessor)level) % 10.0f >= 5.0f ? QOLPartialModels.SHADOW_RADIANCE_CHESTPLATE_PROPELLERS : QOLPartialModels.SHADOW_RADIANCE_CHESTPLATE_PROPELLERS_ALT;
        SuperByteBuffer propellers = CachedBuffers.partial((PartialModel)partial, (BlockState)renderedState);
        propellers.light(light).renderInto(ms, buffer.getBuffer(renderType));
    }

    public static void addEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        GoggleArmorLayer.registerOnAll(dispatcher);
    }

    public static void registerEntityRendererLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(STATUE, StatueModel::createBodyLayer);
        event.registerLayerDefinition(STATUE_INNER_ARMOR, () -> ArmorStandArmorModel.createBodyLayer((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION));
        event.registerLayerDefinition(STATUE_OUTER_ARMOR, () -> ArmorStandArmorModel.createBodyLayer((CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION));
    }

    public static void onClientTick(ClientTickEvent.Post event) {
        ArmorsArmsRenderer.clientTick();
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null && minecraft.level != null && !minecraft.isPaused() && !minecraft.player.isSpectator()) {
            ItemStack chest = minecraft.player.getItemBySlot(EquipmentSlot.CHEST);
            Item item = chest.getItem();
            if (!chest.isEmpty() && item instanceof ShadowRadianceChestplate && CreateQOLClient.isFlying((Player)minecraft.player) && !minecraft.player.isCreative() && minecraft.options.particles().get() != ParticleStatus.MINIMAL) {
                CreateQOLClient.showJetpackParticles(minecraft);
            }
        }
    }

    private static void showJetpackParticles(Minecraft minecraft) {
        double[] dArray;
        LocalPlayer player = minecraft.player;
        Random rand = new Random();
        float random = (rand.nextFloat() - 0.5f) * 0.1f;
        if (player.isCrouching()) {
            double[] dArray2 = new double[2];
            dArray2[0] = -0.3;
            dArray = dArray2;
            dArray2[1] = -0.1;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 0.0;
            dArray = dArray3;
            dArray3[1] = 0.0;
        }
        double[] sneakBonus = dArray;
        Pos3D playerPos = new Pos3D((Entity)player).translate(0.0, 1.5, 0.0);
        Pos3D vCenter = new Pos3D((rand.nextFloat() - 0.5f) * 0.25f, -0.9 + sneakBonus[1], -0.5 + sneakBonus[0]).rotate(player.yBodyRot, 0.0f);
        Pos3D v = playerPos.translate((Vec3)vCenter).translate((Vec3)new Pos3D(player.getDeltaMovement()));
        SimpleParticleType particle = player.isUnderWater() ? ParticleTypes.BUBBLE : new AirParticleData(0.0f, 0.002f);
        minecraft.particleEngine.createParticle((ParticleOptions)particle, v.x, v.y, v.z, (double)random, -0.2, (double)random);
    }

    public static boolean isFlying(Player player) {
        Item item;
        ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof ShadowRadianceChestplate && ShadowRadianceChestplate.isFansEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty()) {
            if (ShadowRadianceChestplate.isHoverEnable(stack)) {
                return !player.onGround();
            }
            return CommonKeysHandler.isHoldingUp(player);
        }
        return false;
    }

    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)livingEntity;
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        if (!(legs.getItem() instanceof ShadowSteelArmorItem) && !(legs.getItem() instanceof ShadowRadianceArmorItem)) {
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)legs.getOrDefault(QOLDataComponents.VOID_WALK, (Object)true)).booleanValue()) {
            return;
        }
        Level level = player.level();
        boolean isOverVoid = !(!level.isEmptyBlock(player.blockPosition().below()) && level.loadedAndEntityCanStandOn(player.blockPosition().below(), (Entity)player) || level.getHeight(Heightmap.Types.MOTION_BLOCKING, player.getBlockX(), player.getBlockZ()) != level.getMinBuildHeight() && !(player.getY() <= (double)level.getMinBuildHeight()));
        boolean isSneaking = player.isCrouching();
        if (isOverVoid && !isSneaking) {
            player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
            player.setOnGround(true);
            player.hurtMarked = true;
        }
    }

    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player p = event.getEntity();
        if (!p.level().isClientSide || !(p instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)p;
        if (player.getAbilities().flying) {
            return;
        }
        ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
        if (!(legs.getItem() instanceof ShadowSteelArmorItem) && !(legs.getItem() instanceof ShadowRadianceArmorItem)) {
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)legs.getOrDefault(QOLDataComponents.VOID_WALK, (Object)true)).booleanValue()) {
            return;
        }
        Level level = player.level();
        boolean hasVoidUnder = true;
        for (int y = player.getBlockY(); y >= level.getMinBuildHeight(); --y) {
            if (level.getBlockState(new BlockPos(player.getBlockX(), y, player.getBlockZ())).isAir()) continue;
            hasVoidUnder = false;
            break;
        }
        if (hasVoidUnder) {
            player.setDeltaMovement(new Vec3(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z));
            player.hurtMarked = true;
            player.setOnGround(true);
            float f = player.onGround() && !player.isDeadOrDying() && !player.isSwimming() ? Math.min(0.1f, (float)player.getDeltaMovement().horizontalDistance()) : 0.0f;
            player.bob += (f - player.bob) * 0.4f;
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class TickEvents {
        @SubscribeEvent
        public static void onTickPre(ClientTickEvent.Pre event) {
            TickEvents.onTick(true);
        }

        @SubscribeEvent
        public static void onTickPost(ClientTickEvent.Post event) {
            TickEvents.onTick(false);
        }

        public static void onTick(boolean isPreEvent) {
            if (!PonderClient.isGameActive()) {
                return;
            }
            ClientLevel world = Minecraft.getInstance().level;
            if (isPreEvent) {
                return;
            }
            EnderRenderer.tick();
        }
    }
}

